/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSecret;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsECDomain;
import java.io.IOException;

public class BcTlsECDH
implements TlsAgreement {
    protected final BcTlsECDomain domain;
    protected AsymmetricCipherKeyPair localKeyPair;
    protected ECPublicKeyParameters peerPublicKey;

    public BcTlsECDH(BcTlsECDomain bcTlsECDomain) {
        this.domain = bcTlsECDomain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        this.localKeyPair = this.domain.generateKeyPair();
        return this.domain.encodePublicKey((ECPublicKeyParameters)this.localKeyPair.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] byArray) throws IOException {
        this.peerPublicKey = this.domain.decodePublicKey(byArray);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        return this.domain.calculateECDHAgreement((ECPrivateKeyParameters)this.localKeyPair.getPrivate(), this.peerPublicKey);
    }
}

