/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.SecretWithEncapsulation;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMExtractor;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyPairGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsKemConfig;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsKemDomain;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsMLKem;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;

public class BcTlsMLKemDomain
implements TlsKemDomain {
    protected final BcTlsCrypto crypto;
    protected final KyberParameters kyberParameters;
    protected final boolean isServer;

    protected static KyberParameters getKyberParameters(int n) {
        switch (n) {
            case 583: {
                return KyberParameters.kyber512;
            }
            case 584: 
            case 1896: {
                return KyberParameters.kyber768;
            }
            case 585: 
            case 4132: {
                return KyberParameters.kyber1024;
            }
        }
        return null;
    }

    public BcTlsMLKemDomain(BcTlsCrypto bcTlsCrypto, TlsKemConfig tlsKemConfig) {
        this.crypto = bcTlsCrypto;
        this.kyberParameters = BcTlsMLKemDomain.getKyberParameters(tlsKemConfig.getNamedGroup());
        this.isServer = tlsKemConfig.isServer();
    }

    public BcTlsSecret adoptLocalSecret(byte[] byArray) {
        return this.crypto.adoptLocalSecret(byArray);
    }

    @Override
    public TlsAgreement createKem() {
        return new BcTlsMLKem(this);
    }

    public BcTlsSecret decapsulate(KyberPrivateKeyParameters kyberPrivateKeyParameters, byte[] byArray) {
        KyberKEMExtractor kyberKEMExtractor = new KyberKEMExtractor(kyberPrivateKeyParameters);
        byte[] byArray2 = kyberKEMExtractor.extractSecret(byArray);
        return this.adoptLocalSecret(byArray2);
    }

    public KyberPublicKeyParameters decodePublicKey(byte[] byArray) {
        return new KyberPublicKeyParameters(this.kyberParameters, byArray);
    }

    public SecretWithEncapsulation encapsulate(KyberPublicKeyParameters kyberPublicKeyParameters) {
        KyberKEMGenerator kyberKEMGenerator = new KyberKEMGenerator(this.crypto.getSecureRandom());
        return kyberKEMGenerator.generateEncapsulated(kyberPublicKeyParameters);
    }

    public byte[] encodePublicKey(KyberPublicKeyParameters kyberPublicKeyParameters) {
        return kyberPublicKeyParameters.getEncoded();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        KyberKeyPairGenerator kyberKeyPairGenerator = new KyberKeyPairGenerator();
        kyberKeyPairGenerator.init(new KyberKeyGenerationParameters(this.crypto.getSecureRandom(), this.kyberParameters));
        return kyberKeyPairGenerator.generateKeyPair();
    }

    public boolean isServer() {
        return this.isServer;
    }
}

