/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.Certificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureScheme;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSASigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSA13Signer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSASigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd25519Signer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd448Signer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAPSSSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSASigner;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;

public class JcaDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static JcaTlsCertificate getEndEntity(JcaTlsCrypto jcaTlsCrypto, Certificate certificate) throws IOException {
        if (certificate == null || certificate.isEmpty()) {
            throw new IllegalArgumentException("No certificate");
        }
        return JcaTlsCertificate.convert(jcaTlsCrypto, certificate.getCertificateAt(0));
    }

    private static TlsSigner makeSigner(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        TlsSigner tlsSigner;
        String string = privateKey.getAlgorithm();
        if (privateKey instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(string) || "RSASSA-PSS".equalsIgnoreCase(string)) {
            PublicKey publicKey;
            int n;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isRSAPSS(n = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new JcaTlsRSAPSSSigner(jcaTlsCrypto, privateKey, n);
            }
            try {
                publicKey = JcaDefaultTlsCredentialedSigner.getEndEntity(jcaTlsCrypto, certificate).getPubKeyRSA();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            tlsSigner = new JcaTlsRSASigner(jcaTlsCrypto, privateKey, publicKey);
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsDSASigner(jcaTlsCrypto, privateKey);
        } else if (ECUtil.isECPrivateKey(privateKey)) {
            int n;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isECDSA(n = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new JcaTlsECDSA13Signer(jcaTlsCrypto, privateKey, n);
            }
            tlsSigner = new JcaTlsECDSASigner(jcaTlsCrypto, privateKey);
        } else if ("Ed25519".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsEd25519Signer(jcaTlsCrypto, privateKey);
        } else if ("Ed448".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsEd448Signer(jcaTlsCrypto, privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return tlsSigner;
    }

    public JcaDefaultTlsCredentialedSigner(TlsCryptoParameters tlsCryptoParameters, JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(tlsCryptoParameters, JcaDefaultTlsCredentialedSigner.makeSigner(jcaTlsCrypto, privateKey, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

