/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DigitallySigned;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureScheme;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsStreamVerifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsVerifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.RSAUtil;
import java.io.IOException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class JcaTlsRSAPSSVerifier
implements TlsVerifier {
    private final JcaTlsCrypto crypto;
    private final PublicKey publicKey;
    private final int signatureScheme;

    public JcaTlsRSAPSSVerifier(JcaTlsCrypto jcaTlsCrypto, PublicKey publicKey, int n) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        if (!SignatureScheme.isRSAPSS(n)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.crypto = jcaTlsCrypto;
        this.publicKey = publicKey;
        this.signatureScheme = n;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        int n = SignatureScheme.getCryptoHashAlgorithm(this.signatureScheme);
        String string = this.crypto.getDigestName(n);
        String string2 = RSAUtil.getDigestSigAlgName(string) + "WITHRSAANDMGF1";
        AlgorithmParameterSpec algorithmParameterSpec = RSAUtil.getPSSParameterSpec(n, string, this.crypto.getHelper());
        return this.crypto.createStreamVerifier(string2, algorithmParameterSpec, digitallySigned.getSignature(), this.publicKey);
    }
}

