/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.DERNull;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.DigestInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsStreamSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public class JcaTlsRSASigner
implements TlsSigner {
    private final JcaTlsCrypto crypto;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private Signature rawSigner = null;

    public JcaTlsRSASigner(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, PublicKey publicKey) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == privateKey) {
            throw new NullPointerException("privateKey");
        }
        this.crypto = jcaTlsCrypto;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        try {
            byte[] byArray2;
            Object object;
            Signature signature = this.getRawSigner();
            if (signatureAndHashAlgorithm != null) {
                if (signatureAndHashAlgorithm.getSignature() != 1) {
                    throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
                }
                object = new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(signatureAndHashAlgorithm.getHash()), DERNull.INSTANCE);
                byArray2 = new DigestInfo((AlgorithmIdentifier)object, byArray).getEncoded();
            } else {
                byArray2 = byArray;
            }
            signature.update(byArray2, 0, byArray2.length);
            object = signature.sign();
            signature.initVerify(this.publicKey);
            signature.update(byArray2, 0, byArray2.length);
            if (signature.verify((byte[])object)) {
                Object object2 = object;
                return object2;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
        finally {
            this.rawSigner = null;
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        if (signatureAndHashAlgorithm != null && 1 == signatureAndHashAlgorithm.getSignature() && JcaUtils.isSunMSCAPIProviderActive() && this.isSunMSCAPIRawSigner()) {
            return this.crypto.createVerifyingStreamSigner(signatureAndHashAlgorithm, this.privateKey, true, this.publicKey);
        }
        return null;
    }

    protected Signature getRawSigner() throws GeneralSecurityException {
        if (this.rawSigner == null) {
            this.rawSigner = this.crypto.getHelper().createSignature("NoneWithRSA");
            this.rawSigner.initSign(this.privateKey, this.crypto.getSecureRandom());
        }
        return this.rawSigner;
    }

    protected boolean isSunMSCAPIRawSigner() throws IOException {
        try {
            Signature signature = this.getRawSigner();
            return JcaUtils.isSunMSCAPIProvider(signature.getProvider());
        }
        catch (GeneralSecurityException generalSecurityException) {
            return true;
        }
    }
}

