/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.io.OutputStreamFactory;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsStreamSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;

class JcaVerifyingStreamSigner
implements TlsStreamSigner {
    private final Signature signer;
    private final Signature verifier;
    private final OutputStream output;

    JcaVerifyingStreamSigner(Signature signature, Signature signature2) {
        OutputStream outputStream = OutputStreamFactory.createStream(signature);
        OutputStream outputStream2 = OutputStreamFactory.createStream(signature2);
        this.signer = signature;
        this.verifier = signature2;
        this.output = new TeeOutputStream(outputStream, outputStream2);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.output;
    }

    @Override
    public byte[] getSignature() throws IOException {
        try {
            byte[] byArray = this.signer.sign();
            if (this.verifier.verify(byArray)) {
                return byArray;
            }
        }
        catch (SignatureException signatureException) {
            throw new TlsFatalAlert(80, (Throwable)signatureException);
        }
        throw new TlsFatalAlert(80);
    }
}

