/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsDHUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.DHGroup;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCryptoException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsDHConfig;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsDHDomain;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.DHUtil;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDH;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class JceTlsDHDomain
implements TlsDHDomain {
    protected final JcaTlsCrypto crypto;
    protected final TlsDHConfig dhConfig;
    protected final DHParameterSpec dhSpec;

    private static byte[] encodeValue(DHParameterSpec dHParameterSpec, boolean bl, BigInteger bigInteger) {
        return bl ? BigIntegers.asUnsignedByteArray(JceTlsDHDomain.getValueLength(dHParameterSpec), bigInteger) : BigIntegers.asUnsignedByteArray(bigInteger);
    }

    private static int getValueLength(DHParameterSpec dHParameterSpec) {
        return (dHParameterSpec.getP().bitLength() + 7) / 8;
    }

    public static JceTlsSecret calculateDHAgreement(JcaTlsCrypto jcaTlsCrypto, DHPrivateKey dHPrivateKey, DHPublicKey dHPublicKey, boolean bl) throws IOException {
        try {
            byte[] byArray = jcaTlsCrypto.calculateKeyAgreement("DiffieHellman", dHPrivateKey, dHPublicKey, "TlsPremasterSecret");
            if (bl) {
                int n = JceTlsDHDomain.getValueLength(dHPrivateKey.getParams());
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
                Arrays.fill(byArray, (byte)0);
                byArray = byArray2;
            }
            return jcaTlsCrypto.adoptLocalSecret(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("cannot calculate secret", generalSecurityException);
        }
    }

    public JceTlsDHDomain(JcaTlsCrypto jcaTlsCrypto, TlsDHConfig tlsDHConfig) {
        DHParameterSpec dHParameterSpec;
        DHGroup dHGroup = TlsDHUtils.getDHGroup(tlsDHConfig);
        if (null != dHGroup && null != (dHParameterSpec = DHUtil.getDHParameterSpec(jcaTlsCrypto, dHGroup))) {
            this.crypto = jcaTlsCrypto;
            this.dhConfig = tlsDHConfig;
            this.dhSpec = dHParameterSpec;
            return;
        }
        throw new IllegalArgumentException("No DH configuration provided");
    }

    public JceTlsSecret calculateDHAgreement(DHPrivateKey dHPrivateKey, DHPublicKey dHPublicKey) throws IOException {
        return JceTlsDHDomain.calculateDHAgreement(this.crypto, dHPrivateKey, dHPublicKey, this.dhConfig.isPadded());
    }

    @Override
    public TlsAgreement createDH() {
        return new JceTlsDH(this);
    }

    public BigInteger decodeParameter(byte[] byArray) throws IOException {
        if (this.dhConfig.isPadded() && JceTlsDHDomain.getValueLength(this.dhSpec) != byArray.length) {
            throw new TlsFatalAlert(47);
        }
        return new BigInteger(1, byArray);
    }

    public DHPublicKey decodePublicKey(byte[] byArray) throws IOException {
        try {
            BigInteger bigInteger = this.decodeParameter(byArray);
            KeySpec keySpec = DHUtil.createPublicKeySpec(bigInteger, this.dhSpec);
            KeyFactory keyFactory = this.crypto.getHelper().createKeyFactory("DiffieHellman");
            return (DHPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(40, (Throwable)exception);
        }
    }

    public byte[] encodeParameter(BigInteger bigInteger) throws IOException {
        return JceTlsDHDomain.encodeValue(this.dhSpec, this.dhConfig.isPadded(), bigInteger);
    }

    public byte[] encodePublicKey(DHPublicKey dHPublicKey) throws IOException {
        return JceTlsDHDomain.encodeValue(this.dhSpec, true, dHPublicKey.getY());
    }

    public KeyPair generateKeyPair() throws IOException {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("DiffieHellman");
            keyPairGenerator.initialize(this.dhSpec, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("unable to create key pair", generalSecurityException);
        }
    }
}

