/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;

public class EncodedObjectConverter<T>
implements Converter<T, Object> {
    private final Class<T> type;
    private final Converter<T, ? super CharSequence> converter;

    public EncodedObjectConverter(Class<T> type, Converter<T, ? super CharSequence> converter) {
        this.type = Assert.notNull(type, "Value type cannot be null.");
        this.converter = Assert.notNull(converter, "Value converter cannot be null.");
    }

    @Override
    public Object applyTo(T t) {
        Assert.notNull(t, "Value argument cannot be null.");
        return this.converter.applyTo(t);
    }

    @Override
    public T applyFrom(Object value2) {
        Assert.notNull(value2, "Value argument cannot be null.");
        if (this.type.isInstance(value2)) {
            return this.type.cast(value2);
        }
        if (value2 instanceof CharSequence) {
            return this.converter.applyFrom((CharSequence)value2);
        }
        String msg = "Values must be either String or " + this.type.getName() + " instances. Value type found: " + value2.getClass().getName() + ".";
        throw new IllegalArgumentException(msg);
    }
}

