/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.impl.lang.RedactedSupplier;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Supplier;

public class RedactedValueConverter<T>
implements Converter<T, Object> {
    private final Converter<T, Object> delegate;

    public RedactedValueConverter(Converter<T, Object> delegate) {
        this.delegate = Assert.notNull(delegate, "Delegate cannot be null.");
    }

    @Override
    public Object applyTo(T t) {
        RedactedSupplier<Object> value2 = this.delegate.applyTo(t);
        if (value2 != null && !(value2 instanceof RedactedSupplier)) {
            value2 = new RedactedSupplier<Object>(value2);
        }
        return value2;
    }

    @Override
    public T applyFrom(Object o) {
        if (o instanceof RedactedSupplier) {
            o = ((Supplier)o).get();
        }
        return this.delegate.applyFrom(o);
    }
}

