/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.ParameterMap;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.Parameters;
import io.jsonwebtoken.impl.security.AbstractJwkBuilder;
import io.jsonwebtoken.impl.security.AbstractSecurityBuilder;
import io.jsonwebtoken.impl.security.DefaultJwkSet;
import io.jsonwebtoken.impl.security.JwkBuilderSupplier;
import io.jsonwebtoken.impl.security.JwkConverter;
import io.jsonwebtoken.impl.security.JwkSetConverter;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkSet;
import io.jsonwebtoken.security.JwkSetBuilder;
import io.jsonwebtoken.security.KeyOperationPolicy;
import java.security.Provider;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DefaultJwkSetBuilder
extends AbstractSecurityBuilder<JwkSet, JwkSetBuilder>
implements JwkSetBuilder {
    private KeyOperationPolicy operationPolicy = AbstractJwkBuilder.DEFAULT_OPERATION_POLICY;
    private JwkSetConverter converter = new JwkSetConverter();
    private ParameterMap map = new ParameterMap(Parameters.registry(DefaultJwkSet.KEYS));

    @Override
    public JwkSetBuilder delete(String key) {
        this.map.remove(key);
        return this;
    }

    @Override
    public JwkSetBuilder empty() {
        this.map.clear();
        return this;
    }

    @Override
    public JwkSetBuilder add(String key, Object value2) {
        this.map.put(key, value2);
        return this;
    }

    @Override
    public JwkSetBuilder add(Map<? extends String, ?> m) {
        this.map.putAll(m);
        return this;
    }

    private JwkSetBuilder refresh() {
        JwkConverter jwkConverter = new JwkConverter(new JwkBuilderSupplier(this.provider, this.operationPolicy));
        this.converter = new JwkSetConverter(jwkConverter, this.converter.isIgnoreUnsupported());
        Parameter<Set<Jwk<?>>> param = DefaultJwkSet.param(jwkConverter);
        this.map = new ParameterMap(Parameters.registry(param), this.map, true);
        Set<Jwk<?>> jwks = this.map.get(param);
        if (!Collections.isEmpty(jwks)) {
            for (Jwk<?> jwk : jwks) {
                this.operationPolicy.validate(jwk.getOperations());
            }
        }
        return this;
    }

    @Override
    public JwkSetBuilder provider(Provider provider) {
        super.provider(provider);
        return this.refresh();
    }

    @Override
    public JwkSetBuilder operationPolicy(KeyOperationPolicy policy) throws IllegalArgumentException {
        this.operationPolicy = policy != null ? policy : AbstractJwkBuilder.DEFAULT_OPERATION_POLICY;
        return this.refresh();
    }

    Collection<Jwk<?>> ensureKeys() {
        Collection keys = this.map.get(DefaultJwkSet.KEYS);
        return Collections.isEmpty(keys) ? new LinkedHashSet() : keys;
    }

    @Override
    public JwkSetBuilder add(Jwk<?> jwk) {
        if (jwk != null) {
            this.operationPolicy.validate(jwk.getOperations());
            Collection<Jwk<?>> keys = this.ensureKeys();
            keys.add(jwk);
            this.keys(keys);
        }
        return this;
    }

    @Override
    public JwkSetBuilder add(Collection<Jwk<?>> c) {
        if (!Collections.isEmpty(c)) {
            for (Jwk<?> jwk : c) {
                this.add(jwk);
            }
        }
        return this;
    }

    @Override
    public JwkSetBuilder keys(Collection<Jwk<?>> c) {
        return this.add(DefaultJwkSet.KEYS.getId(), (Object)c);
    }

    @Override
    public JwkSet build() {
        return this.converter.applyFrom(this.map);
    }
}

