/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.proxy;

import java.io.IOException;
import java.net.Authenticator;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import net.lenni0451.commons.httpclient.proxy.SingleProxyAuthenticator;

public class SingleProxySelector
extends ProxySelector {
    private final Proxy proxy;
    private final String username;
    private final String password;
    private final ProxySelector defaultProxySelector;
    private final Authenticator defaultAuthenticator;

    public SingleProxySelector(Proxy proxy, String username, String password) {
        this.proxy = proxy;
        this.username = username;
        this.password = password;
        this.defaultProxySelector = ProxySelector.getDefault();
        this.defaultAuthenticator = null;
    }

    public void set() {
        ProxySelector.setDefault(this);
        if (this.username != null && this.password != null) {
            Authenticator.setDefault(new SingleProxyAuthenticator(this.username, this.password));
        }
    }

    public void reset() {
        ProxySelector.setDefault(this.defaultProxySelector);
        if (this.username != null && this.password != null) {
            Authenticator.setDefault(this.defaultAuthenticator);
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        return Collections.singletonList(this.proxy);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }
}

