/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.imaginary;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.cloudburstmc.math.imaginary.Complexd;
import org.cloudburstmc.math.imaginary.Complexf;
import org.cloudburstmc.math.imaginary.ImaginaryProvider;
import org.cloudburstmc.math.imaginary.Quaterniond;
import org.cloudburstmc.math.imaginary.Quaternionf;

class Imaginary {
    private static final ServiceLoader<ImaginaryProvider> IMAGINARY_PROVIDER_LOADER = ServiceLoader.load(ImaginaryProvider.class);
    private static ImaginaryProvider cached;

    Imaginary() {
    }

    public static ImaginaryProvider provider() {
        if (cached != null) {
            return cached;
        }
        Iterator<ImaginaryProvider> iterator = IMAGINARY_PROVIDER_LOADER.iterator();
        if (!iterator.hasNext()) {
            throw new RuntimeException("Could not initialize imaginary provider as no implementation was provided!");
        }
        cached = iterator.next();
        return cached;
    }

    public static Complexd createComplexd(double x, double y) {
        return Imaginary.provider().createComplexd(x, y);
    }

    public static Complexf createComplexf(float x, float y) {
        return Imaginary.provider().createComplexf(x, y);
    }

    public static Quaterniond createQuaterniond(double x, double y, double z, double w) {
        return Imaginary.provider().createQuaterniond(x, y, z, w);
    }

    public static Quaternionf createQuaternionf(float x, float y, float z, float w) {
        return Imaginary.provider().createQuaternionf(x, y, z, w);
    }
}

