/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2d;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector4f;
import org.cloudburstmc.math.vector.Vector4i;
import org.cloudburstmc.math.vector.Vector4l;
import org.cloudburstmc.math.vector.VectorNd;
import org.cloudburstmc.math.vector.Vectord;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector4d
implements Vectord,
Comparable<Vector4d>,
Serializable,
Cloneable {
    public static final Vector4d ZERO = Vector4d.from(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4d UNIT_X = Vector4d.from(1.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4d UNIT_Y = Vector4d.from(0.0f, 1.0f, 0.0f, 0.0f);
    public static final Vector4d UNIT_Z = Vector4d.from(0.0f, 0.0f, 1.0f, 0.0f);
    public static final Vector4d UNIT_W = Vector4d.from(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Vector4d ONE = Vector4d.from(1.0f, 1.0f, 1.0f, 1.0f);

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract double getW();

    public int getFloorX() {
        return GenericMath.floor(this.getX());
    }

    public int getFloorY() {
        return GenericMath.floor(this.getY());
    }

    public int getFloorZ() {
        return GenericMath.floor(this.getZ());
    }

    public int getFloorW() {
        return GenericMath.floor(this.getW());
    }

    @Nonnull
    public Vector4d add(Vector4d v) {
        return this.add(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4d add(float x, float y, float z, float w) {
        return this.add((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public abstract Vector4d add(double var1, double var3, double var5, double var7);

    @Nonnull
    public Vector4d sub(Vector4d v) {
        return this.sub(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4d sub(float x, float y, float z, float w) {
        return this.sub((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public abstract Vector4d sub(double var1, double var3, double var5, double var7);

    @Nonnull
    public Vector4d mul(float a) {
        return this.mul((double)a);
    }

    @Override
    @Nonnull
    public Vector4d mul(double a) {
        return this.mul(a, a, a, a);
    }

    @Nonnull
    public Vector4d mul(Vector4d v) {
        return this.mul(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4d mul(float x, float y, float z, float w) {
        return this.mul((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public abstract Vector4d mul(double var1, double var3, double var5, double var7);

    @Nonnull
    public Vector4d div(float a) {
        return this.div((double)a);
    }

    @Override
    @Nonnull
    public Vector4d div(double a) {
        return this.div(a, a, a, a);
    }

    @Nonnull
    public Vector4d div(Vector4d v) {
        return this.div(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4d div(float x, float y, float z, float w) {
        return this.div((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public abstract Vector4d div(double var1, double var3, double var5, double var7);

    public double dot(Vector4d v) {
        return this.dot(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public double dot(float x, float y, float z, float w) {
        return this.dot((double)x, (double)y, (double)z, (double)w);
    }

    public double dot(double x, double y, double z, double w) {
        return this.getX() * x + this.getY() * y + this.getZ() * z + this.getW() * w;
    }

    @Nonnull
    public Vector4d project(Vector4d v) {
        return this.project(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4d project(float x, float y, float z, float w) {
        return this.project((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public abstract Vector4d project(double var1, double var3, double var5, double var7);

    @Nonnull
    public Vector4d pow(float pow) {
        return this.pow((double)pow);
    }

    @Override
    @Nonnull
    public abstract Vector4d pow(double var1);

    @Override
    @Nonnull
    public abstract Vector4d ceil();

    @Override
    @Nonnull
    public abstract Vector4d floor();

    @Override
    @Nonnull
    public abstract Vector4d round();

    @Override
    @Nonnull
    public abstract Vector4d abs();

    @Override
    @Nonnull
    public abstract Vector4d negate();

    @Nonnull
    public Vector4d min(Vector4d v) {
        return this.min(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4d min(float x, float y, float z, float w) {
        return this.min((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public abstract Vector4d min(double var1, double var3, double var5, double var7);

    @Nonnull
    public Vector4d max(Vector4d v) {
        return this.max(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4d max(float x, float y, float z, float w) {
        return this.max((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public abstract Vector4d max(double var1, double var3, double var5, double var7);

    public double distanceSquared(Vector4d v) {
        return this.distanceSquared(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public double distanceSquared(float x, float y, float z, float w) {
        return this.distanceSquared((double)x, (double)y, (double)z, (double)w);
    }

    public double distanceSquared(double x, double y, double z, double w) {
        double dx = this.getX() - x;
        double dy = this.getY() - y;
        double dz = this.getZ() - z;
        double dw = this.getW() - w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public double distance(Vector4d v) {
        return this.distance(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public double distance(float x, float y, float z, float w) {
        return this.distance((double)x, (double)y, (double)z, (double)w);
    }

    public double distance(double x, double y, double z, double w) {
        return Math.sqrt(this.distanceSquared(x, y, z, w));
    }

    @Override
    public double lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ() + this.getW() * this.getW();
    }

    @Override
    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public abstract Vector4d normalize();

    @Override
    public int getMinAxis() {
        double value2 = this.getX();
        int axis = 0;
        if (this.getY() < value2) {
            value2 = this.getY();
            axis = 1;
        }
        if (this.getZ() < value2) {
            value2 = this.getZ();
            axis = 2;
        }
        if (this.getW() < value2) {
            axis = 3;
        }
        return axis;
    }

    @Override
    public int getMaxAxis() {
        double value2 = this.getX();
        int axis = 0;
        if (this.getY() > value2) {
            value2 = this.getY();
            axis = 1;
        }
        if (this.getZ() > value2) {
            value2 = this.getZ();
            axis = 2;
        }
        if (this.getW() > value2) {
            axis = 3;
        }
        return axis;
    }

    @Nonnull
    public Vector2d toVector2() {
        return Vector2d.from(this);
    }

    @Nonnull
    public Vector3d toVector3() {
        return Vector3d.from(this);
    }

    @Nonnull
    public VectorNd toVectorN() {
        return VectorNd.from(this);
    }

    @Override
    @Nonnull
    public double[] toArray() {
        return new double[]{this.getX(), this.getY(), this.getZ(), this.getW()};
    }

    @Override
    @Nonnull
    public Vector4i toInt() {
        return Vector4i.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4l toLong() {
        return Vector4l.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4f toFloat() {
        return Vector4f.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4d toDouble() {
        return Vector4d.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    public int compareTo(Vector4d v) {
        return (int)Math.signum(this.lengthSquared() - v.lengthSquared());
    }

    @Nonnull
    public Vector4d clone() {
        return Vector4d.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ", " + this.getW() + ")";
    }

    @Nonnull
    public static Vector4d from(double n) {
        return Vector4d.from(n, n, n, n);
    }

    @Nonnull
    public static Vector4d from(Vector2d v) {
        return Vector4d.from(v, 0.0f, 0.0f);
    }

    @Nonnull
    public static Vector4d from(Vector2d v, float z, float w) {
        return Vector4d.from(v, (double)z, (double)w);
    }

    @Nonnull
    public static Vector4d from(Vector2d v, double z, double w) {
        return Vector4d.from(v.getX(), v.getY(), z, w);
    }

    @Nonnull
    public static Vector4d from(Vector3d v) {
        return Vector4d.from(v, 0.0f);
    }

    @Nonnull
    public static Vector4d from(Vector3d v, float w) {
        return Vector4d.from(v, (double)w);
    }

    @Nonnull
    public static Vector4d from(Vector3d v, double w) {
        return Vector4d.from(v.getX(), v.getY(), v.getZ(), w);
    }

    @Nonnull
    public static Vector4d from(Vector4d v) {
        return Vector4d.from(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public static Vector4d from(VectorNd v) {
        return Vector4d.from(v.get(0), v.get(1), v.size() > 2 ? v.get(2) : 0.0, v.size() > 3 ? v.get(3) : 0.0);
    }

    @Nonnull
    public static Vector4d from(float x, float y, float z, float w) {
        return Vector4d.from((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public static Vector4d from(double x, double y, double z, double w) {
        return Vectors.createVector4d(x, y, z, w);
    }
}

