/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.nbt;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class IntegerInternPool {
    private static final Map<Object, WeakInteger> CACHE = new ConcurrentSkipListMap<Object, WeakInteger>((a, b) -> {
        if (a instanceof Integer) {
            return Integer.compare((Integer)a, ((WeakInteger)b).value);
        }
        return Integer.compare(((WeakInteger)a).value, ((WeakInteger)b).value);
    });
    private static final ReferenceQueue<?>[] REFERENCE_QUEUES = (ReferenceQueue[])IntStream.range(0, Runtime.getRuntime().availableProcessors()).mapToObj(i -> new ReferenceQueue()).toArray(ReferenceQueue[]::new);

    private static void expungeStaleEntries(@NonNull ReferenceQueue<?> referenceQueue) {
        WeakInteger entry;
        while ((entry = (WeakInteger)referenceQueue.poll()) != null) {
            CACHE.remove(entry, entry);
        }
    }

    public static Integer intern(int value2) {
        Integer interned;
        if ((byte)value2 == value2) {
            return value2;
        }
        Integer boxed = value2;
        WeakInteger entry = CACHE.get(boxed);
        if (entry != null) {
            IntegerInternPool.expungeStaleEntries(entry.referenceQueue);
            interned = (Integer)entry.get();
            if (interned != null) {
                return interned;
            }
        }
        WeakInteger newEntry = new WeakInteger(boxed, REFERENCE_QUEUES[ThreadLocalRandom.current().nextInt(REFERENCE_QUEUES.length)]);
        do {
            if ((entry = CACHE.putIfAbsent(newEntry, newEntry)) != null) {
                IntegerInternPool.expungeStaleEntries(entry.referenceQueue);
                interned = (Integer)entry.get();
                continue;
            }
            interned = boxed;
        } while (interned == null);
        return interned;
    }

    private static final class WeakInteger
    extends WeakReference<Integer> {
        private final int value;
        private final ReferenceQueue<?> referenceQueue;

        public WeakInteger(@NonNull Integer value2, @NonNull ReferenceQueue referenceQueue) {
            super(value2, referenceQueue);
            this.value = value2;
            this.referenceQueue = referenceQueue;
        }
    }
}

