/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.nbt.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class VarInts {
    private VarInts() {
    }

    public static void writeInt(DataOutput buffer, int value2) throws IOException {
        VarInts.encode(buffer, (long)(value2 << 1 ^ value2 >> 31) & 0xFFFFFFFFL);
    }

    public static int readInt(DataInput buffer) throws IOException {
        int n = (int)VarInts.decode(buffer, 32);
        return n >>> 1 ^ -(n & 1);
    }

    public static void writeUnsignedInt(DataOutput buffer, long value2) throws IOException {
        VarInts.encode(buffer, value2 & 0xFFFFFFFFL);
    }

    public static int readUnsignedInt(DataInput buffer) throws IOException {
        return (int)VarInts.decode(buffer, 32);
    }

    public static void writeLong(DataOutput buffer, long value2) throws IOException {
        VarInts.encode(buffer, value2 << 1 ^ value2 >> 63);
    }

    public static long readLong(DataInput buffer) throws IOException {
        long n = VarInts.decode(buffer, 64);
        return n >>> 1 ^ -(n & 1L);
    }

    public static void writeUnsignedLong(DataOutput buffer, long value2) throws IOException {
        VarInts.encode(buffer, value2);
    }

    public static long readUnsignedLong(DataInput buffer) throws IOException {
        return VarInts.decode(buffer, 64);
    }

    private static void encode(DataOutput out, long value2) throws IOException {
        if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            out.writeByte((byte)value2);
        } else if ((value2 & 0xFFFFFFFFFFFFC000L) == 0L) {
            byte[] bytes = new byte[]{(byte)(value2 & 0x7FL | 0x80L), (byte)(value2 >>> 7)};
            out.write(bytes);
        } else {
            VarInts.encodeFull(out, value2);
        }
    }

    private static void encodeFull(DataOutput out, long value2) throws IOException {
        byte[] bytes = (value2 & 0xFFFFFFFFFFE00000L) == 0L ? new byte[]{(byte)(value2 & 0x7FL | 0x80L), (byte)(value2 >>> 7 & 0x7FL | 0x80L), (byte)(value2 >>> 14)} : ((value2 & 0xFFFFFFFFF0000000L) == 0L ? new byte[]{(byte)(value2 & 0x7FL | 0x80L), (byte)(value2 >>> 7 & 0x7FL | 0x80L), (byte)(value2 >>> 14 & 0x7FL | 0x80L), (byte)(value2 >>> 21)} : ((value2 & 0xFFFFFFF800000000L) == 0L ? new byte[]{(byte)(value2 & 0x7FL | 0x80L), (byte)(value2 >>> 7 & 0x7FL | 0x80L), (byte)(value2 >>> 14 & 0x7FL | 0x80L), (byte)(value2 >>> 21 & 0x7FL | 0x80L), (byte)(value2 >>> 28)} : ((value2 & 0xFFFFFC0000000000L) == 0L ? new byte[]{(byte)(value2 & 0x7FL | 0x80L), (byte)(value2 >>> 7 & 0x7FL | 0x80L), (byte)(value2 >>> 14 & 0x7FL | 0x80L), (byte)(value2 >>> 21 & 0x7FL | 0x80L), (byte)(value2 >>> 28 & 0x7FL | 0x80L), (byte)(value2 >>> 35)} : ((value2 & 0xFFFE000000000000L) == 0L ? new byte[]{(byte)(value2 & 0x7FL | 0x80L), (byte)(value2 >>> 7 & 0x7FL | 0x80L), (byte)(value2 >>> 14 & 0x7FL | 0x80L), (byte)(value2 >>> 21 & 0x7FL | 0x80L), (byte)(value2 >>> 28 & 0x7FL | 0x80L), (byte)(value2 >>> 35 & 0x7FL | 0x80L), (byte)(value2 >>> 42)} : ((value2 & 0xFF00000000000000L) == 0L ? new byte[]{(byte)(value2 & 0x7FL | 0x80L), (byte)(value2 >>> 7 & 0x7FL | 0x80L), (byte)(value2 >>> 14 & 0x7FL | 0x80L), (byte)(value2 >>> 21 & 0x7FL | 0x80L), (byte)(value2 >>> 28 & 0x7FL | 0x80L), (byte)(value2 >>> 35 & 0x7FL | 0x80L), (byte)(value2 >>> 42 & 0x7FL | 0x80L), (byte)(value2 >>> 49)} : ((value2 & Long.MIN_VALUE) == 0L ? new byte[]{(byte)(value2 & 0x7FL | 0x80L), (byte)(value2 >>> 7 & 0x7FL | 0x80L), (byte)(value2 >>> 14 & 0x7FL | 0x80L), (byte)(value2 >>> 21 & 0x7FL | 0x80L), (byte)(value2 >>> 28 & 0x7FL | 0x80L), (byte)(value2 >>> 35 & 0x7FL | 0x80L), (byte)(value2 >>> 42 & 0x7FL | 0x80L), (byte)(value2 >>> 49 & 0x7FL | 0x80L), (byte)(value2 >>> 56)} : new byte[]{(byte)(value2 & 0x7FL | 0x80L), (byte)(value2 >>> 7 & 0x7FL | 0x80L), (byte)(value2 >>> 14 & 0x7FL | 0x80L), (byte)(value2 >>> 21 & 0x7FL | 0x80L), (byte)(value2 >>> 28 & 0x7FL | 0x80L), (byte)(value2 >>> 35 & 0x7FL | 0x80L), (byte)(value2 >>> 42 & 0x7FL | 0x80L), (byte)(value2 >>> 49 & 0x7FL | 0x80L), (byte)(value2 >>> 56 & 0x7FL | 0x80L), (byte)(value2 >>> 63)}))))));
        out.write(bytes);
    }

    private static long decode(DataInput buffer, int maxBits) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < maxBits; shift += 7) {
            byte b = buffer.readByte();
            result |= ((long)b & 0x7FL) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new ArithmeticException("VarInt was too large");
    }
}

