/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.nbt.util.stream;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LittleEndianDataOutputStream
implements DataOutput,
Closeable {
    protected final DataOutputStream stream;

    public LittleEndianDataOutputStream(OutputStream stream) {
        this.stream = new DataOutputStream(stream);
    }

    public LittleEndianDataOutputStream(DataOutputStream stream) {
        this.stream = stream;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void write(int bytes) throws IOException {
        this.stream.write(bytes);
    }

    @Override
    public void write(byte @NonNull [] bytes) throws IOException {
        this.stream.write(bytes);
    }

    @Override
    public void write(byte @NonNull [] bytes, int offset, int length) throws IOException {
        this.stream.write(bytes, offset, length);
    }

    @Override
    public void writeBoolean(boolean value2) throws IOException {
        this.stream.writeBoolean(value2);
    }

    @Override
    public void writeByte(int value2) throws IOException {
        this.stream.writeByte(value2);
    }

    @Override
    public void writeShort(int value2) throws IOException {
        this.stream.writeShort(Short.reverseBytes((short)value2));
    }

    @Override
    public void writeChar(int value2) throws IOException {
        this.stream.writeChar(Character.reverseBytes((char)value2));
    }

    @Override
    public void writeInt(int value2) throws IOException {
        this.stream.writeInt(Integer.reverseBytes(value2));
    }

    @Override
    public void writeLong(long value2) throws IOException {
        this.stream.writeLong(Long.reverseBytes(value2));
    }

    @Override
    public void writeFloat(float value2) throws IOException {
        this.stream.writeInt(Integer.reverseBytes(Float.floatToIntBits(value2)));
    }

    @Override
    public void writeDouble(double value2) throws IOException {
        this.stream.writeLong(Long.reverseBytes(Double.doubleToLongBits(value2)));
    }

    @Override
    public void writeBytes(@NonNull String string) throws IOException {
        this.stream.writeBytes(string);
    }

    @Override
    public void writeChars(@NonNull String string) throws IOException {
        this.stream.writeChars(string);
    }

    @Override
    public void writeUTF(@NonNull String string) throws IOException {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        this.writeShort(bytes.length);
        this.write(bytes);
    }
}

