/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.nbt.util.stream;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.util.VarInts;
import org.cloudburstmc.nbt.util.stream.LittleEndianDataOutputStream;

public class NetworkDataOutputStream
extends LittleEndianDataOutputStream {
    public NetworkDataOutputStream(OutputStream stream) {
        super(stream);
    }

    public NetworkDataOutputStream(DataOutputStream stream) {
        super(stream);
    }

    @Override
    public void writeInt(int value2) throws IOException {
        VarInts.writeInt(this.stream, value2);
    }

    @Override
    public void writeLong(long value2) throws IOException {
        VarInts.writeLong(this.stream, value2);
    }

    @Override
    public void writeUTF(@NonNull String string) throws IOException {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        VarInts.writeUnsignedInt(this.stream, bytes.length);
        this.write(bytes);
    }
}

