/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.channel.raknet.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import org.cloudburstmc.netty.channel.raknet.RakPriority;
import org.cloudburstmc.netty.channel.raknet.RakReliability;

public final class RakMessage
extends DefaultByteBufHolder {
    private final RakReliability reliability;
    private final RakPriority priority;
    private final int channel;

    public RakMessage(ByteBuf payloadBuffer) {
        this(payloadBuffer, RakReliability.RELIABLE_ORDERED, RakPriority.NORMAL, 0);
    }

    public RakMessage(ByteBuf payloadBuffer, RakReliability reliability) {
        this(payloadBuffer, reliability, RakPriority.NORMAL, 0);
    }

    public RakMessage(ByteBuf payloadBuffer, RakReliability reliability, RakPriority priority) {
        this(payloadBuffer, reliability, priority, 0);
    }

    public RakMessage(ByteBuf payloadBuffer, RakReliability reliability, RakPriority priority, int channel) {
        super(payloadBuffer);
        this.reliability = reliability;
        this.priority = priority;
        this.channel = channel;
    }

    public RakReliability reliability() {
        return this.reliability;
    }

    public RakPriority priority() {
        return this.priority;
    }

    public int channel() {
        return this.channel;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RakMessage message = (RakMessage)o;
        if (this.reliability != message.reliability) {
            return false;
        }
        if (this.priority != message.priority) {
            return false;
        }
        if (this.channel != message.channel) {
            return false;
        }
        return this.content().equals(message.content());
    }

    @Override
    public int hashCode() {
        int result = this.reliability.hashCode();
        result = 31 * result + this.priority.hashCode();
        result = 31 * result + this.channel;
        result = 31 * result + this.content().hashCode();
        return result;
    }

    @Override
    public RakMessage copy() {
        return (RakMessage)super.copy();
    }

    @Override
    public RakMessage duplicate() {
        return (RakMessage)super.duplicate();
    }

    @Override
    public RakMessage retainedDuplicate() {
        return (RakMessage)super.retainedDuplicate();
    }

    @Override
    public RakMessage replace(ByteBuf content) {
        return new RakMessage(content, this.reliability, this.priority, this.channel);
    }

    @Override
    public RakMessage retain() {
        return (RakMessage)super.retain();
    }

    @Override
    public RakMessage touch() {
        return (RakMessage)super.touch();
    }

    @Override
    public String toString() {
        return "RakMessage{reliability=" + (Object)((Object)this.reliability) + ", priority=" + (Object)((Object)this.priority) + ", channel=" + this.channel + "}";
    }
}

