/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.math.BigInteger;
import java.net.BindException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.ice4j.StackProperties;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.AgentConfig;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidatePairState;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.CheckList;
import org.ice4j.ice.CheckListState;
import org.ice4j.ice.Component;
import org.ice4j.ice.ConnectivityCheckClient;
import org.ice4j.ice.ConnectivityCheckServer;
import org.ice4j.ice.DefaultNominator;
import org.ice4j.ice.FoundationsRegistry;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.KeepAliveStrategy;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.NominationStrategy;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.CandidateHarvesterSet;
import org.ice4j.ice.harvest.HarvestConfig;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvesters;
import org.ice4j.ice.harvest.TrickleCallback;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;
import org.ice4j.util.PeriodicRunnable;
import org.jitsi.utils.concurrent.CustomizableThreadFactory;
import org.jitsi.utils.concurrent.ExecutorFactory;
import org.jitsi.utils.logging2.LogContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class Agent {
    private static final PropertyChangeListener[] NO_STATE_CHANGE_LISTENERS = new PropertyChangeListener[0];
    public static final String PROPERTY_ICE_PROCESSING_STATE = "IceProcessingState";
    private static final ScheduledExecutorService agentTasksScheduler = ExecutorFactory.createSingleThreadScheduledExecutor("ice4j.Agent-timer-", 60, TimeUnit.SECONDS);
    private static final ExecutorService agentTasksExecutor = Executors.newCachedThreadPool(new CustomizableThreadFactory("ice4j.Agent-executor-", true));
    private final Runnable terminationRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Agent.this.terminate(IceProcessingState.TERMINATED);
            Object object = Agent.this.terminationFutureSyncRoot;
            synchronized (object) {
                Agent.this.terminationFuture = null;
            }
        }
    };
    private final StunKeepAliveRunner stunKeepAliveRunner = new StunKeepAliveRunner();
    private final Map<String, IceMediaStream> mediaStreams = new LinkedHashMap<String, IceMediaStream>();
    private final HostCandidateHarvester hostCandidateHarvester = new HostCandidateHarvester();
    private final List<CandidateHarvester> hostHarvesters = new LinkedList<CandidateHarvester>();
    private final CandidateHarvesterSet harvesters;
    private final FoundationsRegistry foundationsRegistry = new FoundationsRegistry();
    private final DefaultNominator nominator;
    private long taValue = -1L;
    private final List<CandidatePair> preDiscoveredPairsQueue = new LinkedList<CandidatePair>();
    private final Object startLock = new Object();
    private final String ufrag;
    private final String password;
    private long tieBreaker;
    private boolean isControlling = true;
    private final ConnectivityCheckClient connCheckClient;
    private final ConnectivityCheckServer connCheckServer;
    private IceProcessingState state = IceProcessingState.WAITING;
    private final Object stateSyncRoot = new Object();
    private final List<PropertyChangeListener> stateListeners = new LinkedList<PropertyChangeListener>();
    private StunStack stunStack;
    private ScheduledFuture<?> terminationFuture;
    private final Object terminationFutureSyncRoot = new Object();
    private int generation = 0;
    private boolean trickle = false;
    private boolean shutdown = false;
    private boolean harvestingStarted = false;
    private boolean performConsentFreshness = false;
    private final Logger logger;
    private boolean useDynamicPorts = HarvestConfig.config.useDynamicPorts();

    public Agent() {
        this(null, null);
    }

    public Agent(Logger parentLogger) {
        this(null, parentLogger);
    }

    public Agent(String ufragPrefix, Logger parentLogger) {
        SecureRandom random = new SecureRandom();
        Object ufrag = ufragPrefix == null ? "" : ufragPrefix;
        ufrag = (String)ufrag + new BigInteger(24, random).toString(32);
        ufrag = (String)ufrag + BigInteger.valueOf(System.currentTimeMillis()).toString(32);
        this.ufrag = ufrag = this.ensureIceAttributeLength((String)ufrag, 4, 256);
        this.logger = parentLogger != null ? parentLogger.createChildLogger(this.getClass().getName(), Collections.singletonMap("ufrag", this.ufrag)) : new LoggerImpl(Agent.class.getName(), new LogContext("ufrag", this.ufrag));
        this.harvesters = new CandidateHarvesterSet(this.logger);
        this.connCheckServer = new ConnectivityCheckServer(this);
        this.connCheckClient = new ConnectivityCheckClient(this, agentTasksScheduler, agentTasksExecutor);
        System.setProperty("org.ice4j.ALWAYS_SIGN", "true");
        this.password = this.ensureIceAttributeLength(new BigInteger(128, random).toString(32), 22, 256);
        this.tieBreaker = random.nextLong() & Long.MAX_VALUE;
        this.nominator = new DefaultNominator(this);
        for (MappingCandidateHarvester harvester : MappingCandidateHarvesters.getHarvesters()) {
            this.addCandidateHarvester(harvester);
        }
        this.logger.debug(() -> "Created a new Agent: " + this.toString() + " with ICE controlling role = " + this.isControlling);
    }

    public void setTieBreaker(long tieBreakerInput) {
        this.tieBreaker = tieBreakerInput;
    }

    public IceMediaStream createMediaStream(String mediaStreamName) {
        this.logger.debug(() -> "Create media stream for " + mediaStreamName);
        IceMediaStream mediaStream = new IceMediaStream(this, mediaStreamName);
        this.mediaStreams.put(mediaStreamName, mediaStream);
        this.setState(IceProcessingState.WAITING);
        return mediaStream;
    }

    public Component createComponent(IceMediaStream stream, int preferredPort, int minPort, int maxPort) throws IllegalArgumentException, IOException, BindException {
        return this.createComponent(stream, preferredPort, minPort, maxPort, KeepAliveStrategy.SELECTED_ONLY, AgentConfig.config.getUseComponentSocket());
    }

    public Component createComponent(IceMediaStream stream, int preferredPort, int minPort, int maxPort, KeepAliveStrategy keepAliveStrategy) throws IllegalArgumentException, IOException, BindException {
        return this.createComponent(stream, preferredPort, minPort, maxPort, keepAliveStrategy, true);
    }

    public Component createComponent(IceMediaStream stream, int preferredPort, int minPort, int maxPort, KeepAliveStrategy keepAliveStrategy, boolean useComponentSocket) throws IllegalArgumentException, IOException, BindException {
        Component component = stream.createComponent(keepAliveStrategy, useComponentSocket);
        this.gatherCandidates(component, preferredPort, minPort, maxPort);
        this.connCheckServer.start();
        return component;
    }

    public Component createComponent(IceMediaStream stream, KeepAliveStrategy keepAliveStrategy, boolean useComponentSocket) throws IllegalArgumentException, IOException {
        return this.createComponent(stream, 0, 0, 0, keepAliveStrategy, useComponentSocket);
    }

    protected CandidatePair createCandidatePair(LocalCandidate local, RemoteCandidate remote) {
        return new CandidatePair(local, remote);
    }

    public void setUseDynamicPorts(boolean value2) {
        this.useDynamicPorts = value2;
    }

    private void gatherCandidates(Component component, int preferredPort, int minPort, int maxPort) throws IllegalArgumentException, IOException {
        this.logger.info("Gathering candidates for component " + component.toShortString() + ".");
        if (this.useDynamicPorts) {
            this.hostCandidateHarvester.harvest(component, preferredPort, minPort, maxPort, Transport.UDP);
        } else if (this.hostHarvesters.isEmpty()) {
            this.logger.warn("No host harvesters available!");
        }
        for (CandidateHarvester harvester : this.hostHarvesters) {
            harvester.harvest(component);
        }
        if (component.getLocalCandidateCount() == 0) {
            this.logger.warn("Failed to gather any host candidates!");
        }
        if (!this.isTrickling()) {
            this.harvestingStarted = true;
            this.harvesters.harvest(component);
        }
        this.logger.debug(() -> "Candidate count in first harvest: " + component.getLocalCandidateCount());
        component.selectDefaultCandidate();
    }

    public void startCandidateTrickle(TrickleCallback trickleCallback) throws IllegalStateException {
        if (!this.isTrickling()) {
            throw new IllegalStateException("Trying to start trickling without enabling it on the agent!");
        }
        if (this.harvestingStarted) {
            this.logger.warn("Hmmm ... why are you harvesting twice? You shouldn't be!");
        }
        LinkedList<Component> components = new LinkedList<Component>();
        for (IceMediaStream stream : this.getStreams()) {
            components.addAll(stream.getComponents());
        }
        this.harvesters.harvest(components, trickleCallback);
        trickleCallback.onIceCandidates(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConnectivityEstablishment() {
        Object object = this.startLock;
        synchronized (object) {
            this.logger.info("Start ICE connectivity establishment.");
            this.shutdown = false;
            this.pruneNonMatchedStreams();
            try {
                this.initCheckLists();
            }
            catch (ArithmeticException e) {
                this.setState(IceProcessingState.FAILED);
                return;
            }
            this.setState(IceProcessingState.RUNNING);
            if (this.preDiscoveredPairsQueue.size() > 0) {
                this.logger.info("Trigger checks for pairs that were received before running state");
                for (CandidatePair cp : this.preDiscoveredPairsQueue) {
                    this.triggerCheck(cp);
                }
                this.preDiscoveredPairsQueue.clear();
            }
            this.connCheckClient.startChecks();
        }
    }

    private void pruneNonMatchedStreams() {
        boolean prune = false;
        block0: for (IceMediaStream stream : this.getStreams()) {
            for (Component component : stream.getComponents()) {
                if (component.getRemoteCandidateCount() > 0) {
                    prune = true;
                }
                if (!prune) continue;
                continue block0;
            }
        }
        if (prune) {
            for (IceMediaStream stream : this.getStreams()) {
                for (Component component : stream.getComponents()) {
                    if (component.getRemoteCandidateCount() != 0) continue;
                    stream.removeComponent(component);
                }
                if (stream.getComponentCount() != 0) continue;
                this.removeStream(stream);
            }
        }
    }

    public boolean isStarted() {
        return this.state != IceProcessingState.WAITING && this.state != IceProcessingState.COMPLETED && this.state != IceProcessingState.TERMINATED;
    }

    public boolean isOver() {
        IceProcessingState state = this.getState();
        return state != null && state.isOver();
    }

    public IceProcessingState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            if (!this.stateListeners.contains(l)) {
                this.stateListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChange(IceProcessingState oldState, IceProcessingState newState) {
        PropertyChangeListener[] stateListenersCopy;
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            stateListenersCopy = this.stateListeners.toArray(NO_STATE_CHANGE_LISTENERS);
        }
        if (stateListenersCopy.length != 0) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, PROPERTY_ICE_PROCESSING_STATE, (Object)oldState, (Object)newState);
            for (PropertyChangeListener l : stateListenersCopy) {
                l.propertyChange(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setState(IceProcessingState newState) {
        IceProcessingState oldState;
        Object object = this.stateSyncRoot;
        synchronized (object) {
            oldState = this.state;
            this.state = newState;
        }
        if (!oldState.equals((Object)newState)) {
            this.logger.info("ICE state changed from " + oldState + " to " + newState + ".");
            this.fireStateChange(oldState, newState);
            return true;
        }
        return false;
    }

    protected void initCheckLists() {
        List<IceMediaStream> streams = this.getStreamsWithPendingConnectivityEstablishment();
        int streamCount = streams.size();
        if (streamCount > 0) {
            int maxCheckListSizePerStream = AgentConfig.config.getMaxCheckListSize() / streamCount;
            for (IceMediaStream stream : streams) {
                this.logger.info("Init checklist for stream " + stream.getName());
                stream.setMaxCheckListSize(maxCheckListSizePerStream);
                stream.initCheckList();
            }
            streams.get(0).getCheckList().computeInitialCheckListPairStates();
        }
    }

    public void addCandidateHarvester(CandidateHarvester harvester) {
        if (harvester.isHostHarvester()) {
            this.hostHarvesters.add(harvester);
        } else {
            this.harvesters.add(harvester);
        }
    }

    public CandidateHarvesterSet getHarvesters() {
        return this.harvesters;
    }

    public String getLocalUfrag() {
        return this.ufrag;
    }

    public String getLocalPassword() {
        return this.password;
    }

    public String generateLocalUserName(String media) {
        String ret;
        IceMediaStream stream = this.getStream(media);
        if (stream == null) {
            ret = null;
            this.logger.warn("Agent contains no IceMediaStream with name " + media + "!");
        } else {
            String remoteUfrag = stream.getRemoteUfrag();
            if (remoteUfrag == null) {
                ret = null;
                this.logger.warn("Remote ufrag of IceMediaStream with name " + media + " is null!");
            } else {
                ret = remoteUfrag + ":" + this.getLocalUfrag();
            }
        }
        return ret;
    }

    public String generateRemoteUserName(String media) {
        IceMediaStream stream = this.getStream(media);
        return stream == null ? null : this.getLocalUfrag() + ":" + stream.getRemoteUfrag();
    }

    public String generateLocalUserName(RemoteCandidate remoteCandidate, LocalCandidate localCandidate) {
        return this.generateUserName(remoteCandidate, localCandidate);
    }

    public String generateRemoteUserName(RemoteCandidate remoteCandidate, LocalCandidate localCandidate) {
        return this.generateUserName(localCandidate, remoteCandidate);
    }

    private String generateUserName(Candidate<?> candidate1, Candidate<?> candidate2) {
        candidate1.getUfrag();
        candidate2.getUfrag();
        return null;
    }

    public final FoundationsRegistry getFoundationsRegistry() {
        return this.foundationsRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceMediaStream getStream(String name) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return this.mediaStreams.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStreamNames() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return new LinkedList<String>(this.mediaStreams.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IceMediaStream> getStreams() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return new LinkedList<IceMediaStream>(this.mediaStreams.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamCount() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return this.mediaStreams.size();
        }
    }

    List<IceMediaStream> getStreamsWithPendingConnectivityEstablishment() {
        List<IceMediaStream> streams = this.getStreams();
        Iterator<IceMediaStream> streamIter = streams.iterator();
        while (streamIter.hasNext()) {
            IceMediaStream stream = streamIter.next();
            CheckList checkList = stream.getCheckList();
            CheckListState checkListState = checkList.getState();
            if (!CheckListState.COMPLETED.equals((Object)checkListState) && !CheckListState.FAILED.equals((Object)checkListState)) continue;
            streamIter.remove();
        }
        return streams;
    }

    public synchronized StunStack getStunStack() {
        if (this.stunStack == null) {
            this.stunStack = new StunStack();
        }
        return this.stunStack;
    }

    public void setStunStack(StunStack stunStack) {
        this.stunStack = stunStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getActiveCheckListCount() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            int i = 0;
            Collection<IceMediaStream> streams = this.mediaStreams.values();
            for (IceMediaStream stream : streams) {
                if (!stream.getCheckList().isActive()) continue;
                ++i;
            }
            return i;
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("ICE Agent (stream-count=");
        buff.append(this.getStreamCount());
        buff.append(" ice-pwd:").append(this.getLocalPassword());
        buff.append(" ice-ufrag:").append(this.getLocalUfrag());
        buff.append(" tie-breaker:").append(this.getTieBreaker());
        buff.append("):\n");
        for (IceMediaStream stream : this.getStreams()) {
            buff.append(stream).append("\n");
        }
        return buff.toString();
    }

    public long getTieBreaker() {
        return this.tieBreaker;
    }

    public void setControlling(boolean isControlling) {
        if (this.isControlling != isControlling) {
            this.logger.info(() -> "Changing agent " + this.toString() + " role from controlling = " + this.isControlling + " to controlling = " + isControlling);
        }
        this.isControlling = isControlling;
        for (IceMediaStream stream : this.getStreams()) {
            CheckList list = stream.getCheckList();
            if (list == null) continue;
            list.recomputePairPriorities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStream(IceMediaStream stream) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            this.mediaStreams.remove(stream.getName());
        }
        stream.free();
    }

    public boolean isControlling() {
        return this.isControlling;
    }

    public LocalCandidate findLocalCandidate(TransportAddress address) {
        return this.findLocalCandidate(address, null);
    }

    public LocalCandidate findLocalCandidate(TransportAddress address, LocalCandidate base) {
        for (IceMediaStream stream : this.mediaStreams.values()) {
            LocalCandidate localCandidate = stream.findLocalCandidate(address, base);
            if (localCandidate == null) continue;
            return localCandidate;
        }
        return null;
    }

    public RemoteCandidate findRemoteCandidate(TransportAddress remoteAddress) {
        for (IceMediaStream stream : this.mediaStreams.values()) {
            RemoteCandidate cnd = stream.findRemoteCandidate(remoteAddress);
            if (cnd == null) continue;
            return cnd;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CandidatePair findCandidatePair(TransportAddress localAddress, TransportAddress remoteAddress) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            for (IceMediaStream stream : this.mediaStreams.values()) {
                CandidatePair pair = stream.findCandidatePair(localAddress, remoteAddress);
                if (pair == null) continue;
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CandidatePair findCandidatePair(String localUFrag, String remoteUFrag) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            for (IceMediaStream stream : this.mediaStreams.values()) {
                CandidatePair pair = stream.findCandidatePair(localUFrag, remoteUFrag);
                if (pair == null) continue;
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean incomingCheckReceived(TransportAddress remoteAddress, TransportAddress localAddress, long priority, String remoteUFrag, String localUFrag, boolean useCandidate) {
        String ufrag = null;
        LocalCandidate localCandidate = this.findLocalCandidate(localAddress);
        if (localCandidate == null) {
            this.logger.info("No localAddress for this incoming checks: " + localAddress);
            return false;
        }
        Component parentComponent = localCandidate.getParentComponent();
        RemoteCandidate remoteCandidate = new RemoteCandidate(remoteAddress, parentComponent, CandidateType.PEER_REFLEXIVE_CANDIDATE, this.foundationsRegistry.obtainFoundationForPeerReflexiveCandidate(), priority, null, ufrag);
        CandidatePair triggeredPair = this.createCandidatePair(localCandidate, remoteCandidate);
        this.logger.debug(() -> "set use-candidate " + useCandidate + " for pair " + triggeredPair.toRedactedShortString());
        if (useCandidate) {
            triggeredPair.setUseCandidateReceived();
        }
        Object object = this.startLock;
        synchronized (object) {
            if (this.state == IceProcessingState.WAITING) {
                this.logger.debug(() -> "Receive STUN checks before our ICE has started");
                this.preDiscoveredPairsQueue.add(triggeredPair);
            } else if (this.state != IceProcessingState.FAILED) {
                this.logger.debug(() -> "Received check from " + triggeredPair.toRedactedShortString() + " triggered a check.");
                return this.triggerCheck(triggeredPair);
            }
        }
        return true;
    }

    private boolean triggerCheck(CandidatePair triggerPair) {
        CandidatePair knownPair = this.findCandidatePair(triggerPair.getLocalCandidate().getTransportAddress(), triggerPair.getRemoteCandidate().getTransportAddress());
        IceMediaStream parentStream = triggerPair.getLocalCandidate().getParentComponent().getParentStream();
        if (knownPair != null) {
            boolean useCand = triggerPair.useCandidateReceived();
            if (useCand) {
                knownPair.setUseCandidateReceived();
            }
            triggerPair = knownPair;
            if (knownPair.getState() == CandidatePairState.SUCCEEDED) {
                if (!this.isControlling() && useCand) {
                    this.logger.debug(() -> "update nominated flag");
                    this.nominationConfirmed(triggerPair);
                    this.checkListStatesUpdated();
                }
                return true;
            }
            if (knownPair.getState() == CandidatePairState.IN_PROGRESS) {
                TransactionID checkTransaction = knownPair.getConnectivityCheckTransaction();
                this.getStunStack().cancelTransaction(checkTransaction);
            }
        } else {
            if (this.connCheckClient.isStopped()) {
                return false;
            }
            if (triggerPair.getParentComponent().getSelectedPair() == null) {
                this.logger.info("Add peer CandidatePair with new reflexive address to checkList: " + triggerPair.toRedactedString());
            }
            parentStream.addToCheckList(triggerPair);
        }
        CheckList checkList = parentStream.getCheckList();
        boolean wasFrozen = checkList.isFrozen();
        checkList.scheduleTriggeredCheck(triggerPair);
        if (wasFrozen && !checkList.isFrozen()) {
            this.connCheckClient.startChecks(checkList);
        }
        return true;
    }

    protected void validatePair(CandidatePair validPair) {
        Component parentComponent = validPair.getParentComponent();
        IceMediaStream parentStream = parentComponent.getParentStream();
        parentStream.addToValidList(validPair);
    }

    public synchronized void nominate(CandidatePair pair) throws IllegalStateException {
        if (!this.isControlling()) {
            throw new IllegalStateException("Only controlling agents can nominate pairs");
        }
        Component parentComponent = pair.getParentComponent();
        IceMediaStream parentStream = parentComponent.getParentStream();
        if (!pair.isNominated() && !parentStream.validListContainsNomineeForComponent(parentComponent)) {
            this.logger.info("verify if nominated pair answer again");
            pair.nominate();
            parentStream.getCheckList().scheduleTriggeredCheck(pair);
        }
    }

    public NominationStrategy getNominationStrategy() {
        return this.nominator.getStrategy();
    }

    public void setNominationStrategy(NominationStrategy strategy) {
        this.nominator.setStrategy(strategy);
    }

    protected void nominationConfirmed(CandidatePair nominatedPair) {
        nominatedPair.nominate();
        Component parentComponent = nominatedPair.getParentComponent();
        IceMediaStream parentStream = parentComponent.getParentStream();
        CheckList checkList = parentStream.getCheckList();
        if (checkList.getState() == CheckListState.RUNNING) {
            checkList.handleNominationConfirmed(nominatedPair);
        }
        if (parentStream.allComponentsHaveSelected() && checkList.getState() == CheckListState.RUNNING) {
            checkList.setState(CheckListState.COMPLETED);
        }
    }

    protected void checkListStatesUpdated() {
        boolean allListsEnded = true;
        boolean atLeastOneListSucceeded = false;
        if (this.getState().isEstablished()) {
            return;
        }
        List<IceMediaStream> streams = this.getStreams();
        for (IceMediaStream stream : streams) {
            CheckListState checkListState = stream.getCheckList().getState();
            if (checkListState == CheckListState.RUNNING) {
                allListsEnded = false;
                break;
            }
            if (checkListState != CheckListState.COMPLETED) continue;
            this.logger.info("CheckList of stream " + stream.getName() + " is COMPLETED");
            atLeastOneListSucceeded = true;
        }
        if (!allListsEnded) {
            return;
        }
        if (!atLeastOneListSucceeded) {
            if (this.logger.isInfoEnabled()) {
                if (this.connCheckClient.isAlive() || this.connCheckServer.isAlive()) {
                    this.logger.info("Suspicious ICE connectivity failure. Checks failed but the remote end was able to reach us.");
                }
                this.logger.info("ICE state is FAILED");
            }
            this.terminate(IceProcessingState.FAILED);
            return;
        }
        if (this.getState() != IceProcessingState.RUNNING) {
            return;
        }
        if (!this.setState(IceProcessingState.COMPLETED)) {
            return;
        }
        this.scheduleStunKeepAlive();
        this.scheduleTermination();
        this.logCandTypes();
    }

    private void logCandTypes() {
        List<IceMediaStream> strms = this.getStreams();
        for (IceMediaStream stream : strms) {
            for (Component component : stream.getComponents()) {
                CandidatePair selectedPair = component.getSelectedPair();
                StringBuffer buf = new StringBuffer("Harvester used for selected pair for ");
                buf.append(component.toShortString());
                buf.append(": ");
                if (selectedPair == null) {
                    buf.append("none (conn checks failed)");
                    this.logger.info(buf.toString());
                    continue;
                }
                LocalCandidate localCnd = selectedPair.getLocalCandidate();
                TransportAddress serverAddr = localCnd.getStunServerAddress();
                buf.append((Object)localCnd.getType());
                if (serverAddr != null) {
                    buf.append(" (STUN server = ");
                    buf.append(serverAddr);
                    buf.append(")");
                } else {
                    TransportAddress relayAddr = localCnd.getRelayServerAddress();
                    if (relayAddr != null) {
                        buf.append(" (relay = ");
                        buf.append(relayAddr);
                        buf.append(")");
                    }
                }
                this.logger.info(buf.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int countHostCandidates() {
        int num = 0;
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            Collection<IceMediaStream> streamsCol = this.mediaStreams.values();
            for (IceMediaStream stream : streamsCol) {
                num += stream.countHostCandidates();
            }
        }
        return num;
    }

    public void setTa(long taValue) {
        this.taValue = taValue;
    }

    protected long calculateTa() {
        if (this.taValue != -1L) {
            return this.taValue;
        }
        return 20L;
    }

    protected long calculateStunHarvestRTO() {
        return Math.max(100L, this.calculateTa() * 2L * (long)this.countHostCandidates());
    }

    protected long calculateStunConnCheckRTO() {
        return 100L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTermination() {
        boolean runTerminationImmediately = false;
        Object object = this.terminationFutureSyncRoot;
        synchronized (object) {
            if (this.terminationFuture == null) {
                long terminationDelay2 = AgentConfig.config.getTerminationDelay().toMillis();
                if (terminationDelay2 > 0L) {
                    this.terminationFuture = agentTasksScheduler.schedule(this.terminationRunnable, terminationDelay2, TimeUnit.MILLISECONDS);
                } else {
                    runTerminationImmediately = true;
                }
            }
        }
        if (runTerminationImmediately) {
            this.terminationRunnable.run();
        }
    }

    private void scheduleStunKeepAlive() {
        boolean noKeepAlives = StackProperties.getBoolean("org.ice4j.NO_KEEP_ALIVES", false);
        if (noKeepAlives || !this.stunKeepAliveRunner.shouldRunStunKeepAlive()) {
            return;
        }
        this.stunKeepAliveRunner.schedule();
    }

    private void terminate(IceProcessingState terminationState) {
        if (!IceProcessingState.FAILED.equals((Object)terminationState) && !IceProcessingState.TERMINATED.equals((Object)terminationState)) {
            throw new IllegalArgumentException("terminationState");
        }
        this.connCheckClient.stop();
        this.setState(terminationState);
    }

    private String ensureIceAttributeLength(String s2, int min, int max) {
        if (s2 == null) {
            throw new NullPointerException("s");
        }
        if (min < 0) {
            throw new IllegalArgumentException("min " + min);
        }
        if (max < min) {
            throw new IllegalArgumentException("max " + max);
        }
        int length = s2.length();
        int numberOfIceCharsToAdd = min - length;
        if (numberOfIceCharsToAdd > 0) {
            StringBuilder sb = new StringBuilder(min);
            while (numberOfIceCharsToAdd > 0) {
                sb.append('0');
                --numberOfIceCharsToAdd;
            }
            sb.append(s2);
            s2 = sb.toString();
        } else if (max < length) {
            s2 = s2.substring(0, max);
        }
        return s2;
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        this.logger.debug(() -> "Free ICE agent");
        this.shutdown = true;
        this.stunKeepAliveRunner.cancel();
        Object object = this.terminationFutureSyncRoot;
        synchronized (object) {
            if (this.terminationFuture != null) {
                this.terminationFuture.cancel(true);
                this.terminationFuture = null;
            }
        }
        this.connCheckServer.stop();
        IceProcessingState state = this.getState();
        if (!IceProcessingState.FAILED.equals((Object)state) && !IceProcessingState.TERMINATED.equals((Object)state)) {
            this.terminate(IceProcessingState.TERMINATED);
        }
        this.getStunStack().shutDown();
        boolean interrupted = false;
        this.logger.debug(() -> "remove streams");
        for (IceMediaStream stream : this.getStreams()) {
            try {
                this.removeStream(stream);
                this.logger.debug("remove stream " + stream.getName());
            }
            catch (Throwable t) {
                this.logger.debug(() -> "remove stream " + stream.getName() + " failed: " + t);
                if (t instanceof InterruptedException) {
                    interrupted = true;
                    continue;
                }
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.logger.debug(() -> "ICE agent freed");
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    private CandidatePair getSelectedPair(String streamName) {
        Component component;
        IceMediaStream stream = this.getStream(streamName);
        if (stream != null && (component = stream.getComponent(1)) != null) {
            return component.getSelectedPair();
        }
        return null;
    }

    public LocalCandidate getSelectedLocalCandidate(String streamName) {
        CandidatePair candidatePair = this.getSelectedPair(streamName);
        return candidatePair == null ? null : candidatePair.getLocalCandidate();
    }

    public RemoteCandidate getSelectedRemoteCandidate(String streamName) {
        CandidatePair candidatePair = this.getSelectedPair(streamName);
        return candidatePair == null ? null : candidatePair.getRemoteCandidate();
    }

    public boolean isTrickling() {
        return this.trickle;
    }

    public void setTrickling(boolean trickle) {
        this.trickle = trickle;
    }

    public long getHarvestingTime(String harvesterName) {
        long harvestingTime = 0L;
        for (CandidateHarvester harvester : this.harvesters) {
            if (!harvester.getClass().getName().endsWith(harvesterName) || (harvestingTime = harvester.getHarvestStatistics().getHarvestDuration()) == 0L) continue;
            return harvestingTime;
        }
        return 0L;
    }

    public int getHarvestCount(String harvesterName) {
        for (CandidateHarvester harvester : this.harvesters) {
            int harvestCount;
            if (!harvester.getClass().getName().endsWith(harvesterName) || (harvestCount = harvester.getHarvestStatistics().getHarvestCount()) == 0) continue;
            return harvestCount;
        }
        return 0;
    }

    public long getTotalHarvestingTime() {
        long harvestDuration = 0L;
        for (CandidateHarvester harvester : this.harvesters) {
            harvestDuration += harvester.getHarvestStatistics().getHarvestDuration();
        }
        return harvestDuration;
    }

    public int getHarvestCount() {
        int harvestCount = 0;
        for (CandidateHarvester harvester : this.harvesters) {
            harvestCount += harvester.getHarvestStatistics().getHarvestCount();
        }
        return harvestCount;
    }

    public boolean getPerformConsentFreshness() {
        return this.performConsentFreshness;
    }

    public void setPerformConsentFreshness(boolean performConsentFreshness) {
        this.performConsentFreshness = performConsentFreshness;
    }

    public void setLoggingLevel(Level level) {
        this.logger.setLevel(level);
    }

    public Level getLoggingLevel() {
        return this.logger.getLevel();
    }

    public Logger getLogger() {
        return this.logger;
    }

    private final class StunKeepAliveRunner
    extends PeriodicRunnable {
        private final long consentFreshnessInterval;
        private final int originalConsentFreshnessWaitInterval;
        private final int maxConsentFreshnessWaitInterval;
        private final int consentFreshnessMaxRetransmissions;
        private int keepAliveSent;

        StunKeepAliveRunner() {
            super(agentTasksScheduler, agentTasksExecutor);
            this.consentFreshnessInterval = AgentConfig.config.getConsentFreshnessInterval().toMillis();
            this.originalConsentFreshnessWaitInterval = (int)AgentConfig.config.getConsentFreshnessOriginalWaitInterval().toMillis();
            this.maxConsentFreshnessWaitInterval = (int)AgentConfig.config.getConsentFreshnessMaxWaitInterval().toMillis();
            this.consentFreshnessMaxRetransmissions = AgentConfig.config.getMaxConsentFreshnessRetransmissions();
            this.keepAliveSent = 0;
        }

        @Override
        protected Duration getDelayUntilNextRun() {
            if (this.shouldRunStunKeepAlive()) {
                if (this.keepAliveSent == 0) {
                    return Duration.ZERO;
                }
                double r = 1.0;
                if (AgentConfig.config.getRandomizeConsentFreshnessInterval()) {
                    r = 0.8 + ThreadLocalRandom.current().nextDouble() * 0.4;
                }
                return Duration.ofMillis((long)((double)this.consentFreshnessInterval * r));
            }
            return Duration.ofMillis(-1L);
        }

        @Override
        protected void run() {
            try {
                this.sendKeepAlive();
            }
            catch (Exception e) {
                Agent.this.logger.warn("Error while sending keep alive", e);
            }
        }

        private void sendKeepAlive() {
            ++this.keepAliveSent;
            for (IceMediaStream stream : Agent.this.getStreams()) {
                for (Component component : stream.getComponents()) {
                    for (CandidatePair pair : component.getKeepAlivePairs()) {
                        if (pair == null) continue;
                        if (Agent.this.performConsentFreshness) {
                            Agent.this.connCheckClient.startCheckForPair(pair, this.originalConsentFreshnessWaitInterval, this.maxConsentFreshnessWaitInterval, this.consentFreshnessMaxRetransmissions);
                            continue;
                        }
                        Agent.this.connCheckClient.sendBindingIndicationForPair(pair);
                    }
                }
            }
        }

        boolean shouldRunStunKeepAlive() {
            IceProcessingState state = Agent.this.state;
            return (IceProcessingState.COMPLETED.equals((Object)state) || IceProcessingState.TERMINATED.equals((Object)state)) && !Agent.this.shutdown;
        }
    }
}

