/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ice4j.ice.Component;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.CandidateHarvesterSetElement;
import org.ice4j.ice.harvest.CandidateHarvesterSetTask;
import org.ice4j.ice.harvest.HarvestConfig;
import org.ice4j.ice.harvest.TrickleCallback;
import org.jitsi.utils.logging2.Logger;

public class CandidateHarvesterSet
extends AbstractSet<CandidateHarvester> {
    private final Logger logger;
    private final Collection<CandidateHarvesterSetElement> elements = new LinkedList<CandidateHarvesterSetElement>();
    private static ExecutorService threadPool = Executors.newCachedThreadPool();

    public CandidateHarvesterSet(Logger logger) {
        this.logger = logger.createChildLogger(CandidateHarvesterSet.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(CandidateHarvester harvester) {
        Collection<CandidateHarvesterSetElement> collection = this.elements;
        synchronized (collection) {
            for (CandidateHarvesterSetElement element : this.elements) {
                if (!element.harvesterEquals(harvester)) continue;
                return false;
            }
            this.elements.add(new CandidateHarvesterSetElement(harvester));
            return true;
        }
    }

    public void harvest(Component component) {
        this.harvest(Arrays.asList(component), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void harvest(List<Component> components, TrickleCallback trickleCallback) {
        Collection<CandidateHarvesterSetElement> collection = this.elements;
        synchronized (collection) {
            this.harvest(this.elements.iterator(), components, threadPool, trickleCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void harvest(Iterator<CandidateHarvesterSetElement> harvesters, List<Component> components, ExecutorService executorService, TrickleCallback trickleCallback) {
        HashMap tasks = new HashMap();
        while (true) {
            ArrayList<Component> componentsCopy;
            CandidateHarvesterSetElement harvester;
            Iterator<CandidateHarvesterSetElement> iterator = harvesters;
            synchronized (iterator) {
                if (!harvesters.hasNext()) {
                    break;
                }
                harvester = harvesters.next();
            }
            if (!harvester.isEnabled()) continue;
            List<Component> list = components;
            synchronized (list) {
                componentsCopy = new ArrayList<Component>(components);
            }
            CandidateHarvesterSetTask task = new CandidateHarvesterSetTask(harvester, componentsCopy, trickleCallback);
            tasks.put(task, executorService.submit(task));
        }
        Iterator taskIter = tasks.entrySet().iterator();
        while (taskIter.hasNext()) {
            Map.Entry task = taskIter.next();
            Future future = (Future)task.getValue();
            while (true) {
                CandidateHarvesterSetElement harvester;
                try {
                    future.get(HarvestConfig.config.timeout().toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    harvester = ((CandidateHarvesterSetTask)task.getKey()).getHarvester();
                    if (harvester != null) {
                        harvester.setEnabled(false);
                    }
                    this.logger.warn("timed out while harvesting from " + harvester);
                }
                catch (CancellationException ce) {
                    this.logger.info("harvester cancelled");
                }
                catch (ExecutionException ee) {
                    harvester = ((CandidateHarvesterSetTask)task.getKey()).getHarvester();
                    this.logger.info("disabling harvester " + harvester.getHarvester() + " due to ExecutionException: " + ee.getLocalizedMessage());
                    if (harvester == null) break;
                    harvester.setEnabled(false);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            taskIter.remove();
        }
    }

    @Override
    public Iterator<CandidateHarvester> iterator() {
        final Iterator<CandidateHarvesterSetElement> elementIter = this.elements.iterator();
        return new Iterator<CandidateHarvester>(){

            @Override
            public boolean hasNext() {
                return elementIter.hasNext();
            }

            @Override
            public CandidateHarvester next() throws NoSuchElementException {
                return ((CandidateHarvesterSetElement)elementIter.next()).getHarvester();
            }

            @Override
            public void remove() throws IllegalStateException, UnsupportedOperationException {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Collection<CandidateHarvesterSetElement> collection = this.elements;
        synchronized (collection) {
            return this.elements.size();
        }
    }
}

