/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp;

import com.phono.srtplight.Log;
import java.util.concurrent.ConcurrentLinkedQueue;
import pe.pi.sctp4j.sctp.Association;
import pe.pi.sctp4j.sctp.SCTPStream;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.ReConfigChunk;
import pe.pi.sctp4j.sctp.messages.params.IncomingSSNResetRequestParameter;
import pe.pi.sctp4j.sctp.messages.params.KnownParam;
import pe.pi.sctp4j.sctp.messages.params.OutgoingSSNResetRequestParameter;
import pe.pi.sctp4j.sctp.messages.params.ReconfigurationResponseParameter;

class ReconfigState {
    ReConfigChunk recentInbound = null;
    ReConfigChunk recentOutboundRequest = null;
    ReConfigChunk sentReply = null;
    boolean timerRunning = false;
    long nearSeqno = 0L;
    long farSeqno = 0L;
    Association assoc;
    ConcurrentLinkedQueue<SCTPStream> listOfStreamsToReset;

    ReconfigState(Association a, long farTSN) {
        this.nearSeqno = a.getNearTSN();
        this.farSeqno = farTSN;
        this.assoc = a;
        this.listOfStreamsToReset = new ConcurrentLinkedQueue();
    }

    private boolean haveSeen(ReConfigChunk rconf) {
        return rconf.sameAs(this.recentInbound);
    }

    private ReConfigChunk getPrevious(ReConfigChunk rconf) {
        return rconf.sameAs(this.recentInbound) ? this.sentReply : null;
    }

    private boolean timerIsRunning() {
        return this.timerRunning;
    }

    private void markAsAcked(ReConfigChunk rconf) {
    }

    private long nextNearNo() {
        return this.nearSeqno++;
    }

    private long nextFarNo() {
        return this.farSeqno++;
    }

    public long nextDue() {
        return 1000L;
    }

    Chunk[] deal(ReConfigChunk rconf) {
        Chunk[] ret = new Chunk[1];
        ReConfigChunk reply = null;
        Log.debug("Got a reconfig message to deal with");
        if (this.haveSeen(rconf)) {
            reply = this.getPrevious(rconf);
        }
        if (reply == null) {
            reply = new ReConfigChunk();
            if (rconf.hasOutgoingReset()) {
                ReconfigurationResponseParameter rep;
                OutgoingSSNResetRequestParameter oreset = rconf.getOutgoingReset();
                int[] streams = oreset.getStreams();
                if (streams.length == 0) {
                    streams = this.assoc.allStreams();
                }
                if (this.timerIsRunning()) {
                    this.markAsAcked(rconf);
                }
                if (oreset.getLastAssignedTSN() > this.assoc.getCumAckPt()) {
                    Log.debug("Last assigned > farTSN " + oreset.getLastAssignedTSN() + " v " + this.assoc.getCumAckPt());
                    for (int s2 : streams) {
                        SCTPStream defstr = this.assoc.getStream(s2);
                        defstr.setDeferred(true);
                    }
                    rep = new ReconfigurationResponseParameter();
                    rep.setSeq(oreset.getReqSeqNo());
                    rep.setResult(6);
                    reply.addParam(rep);
                } else {
                    Log.debug("we are up-to-date ");
                    rep = new ReconfigurationResponseParameter();
                    rep.setSeq(oreset.getReqSeqNo());
                    int result = streams.length > 0 ? 1 : 0;
                    rep.setResult(result);
                    int[] nArray = streams;
                    int n = nArray.length;
                    for (int defstr = 0; defstr < n; ++defstr) {
                        int s3 = nArray[defstr];
                        SCTPStream cstrm = this.assoc.delStream(s3);
                        if (cstrm == null) {
                            Log.error("(re)Close a non existant stream =" + s3);
                            continue;
                        }
                        cstrm.reset();
                    }
                    reply.addParam(rep);
                }
            }
            if (rconf.hasIncomingReset()) {
                IncomingSSNResetRequestParameter ireset = rconf.getIncomingReset();
                OutgoingSSNResetRequestParameter rep = new OutgoingSSNResetRequestParameter(this.nextNearNo(), ireset.getReqNo(), this.assoc.getNearTSN());
                int[] streams = ireset.getStreams();
                rep.setStreams(streams);
                if (streams.length == 0) {
                    streams = this.assoc.allStreams();
                }
                for (int s4 : streams) {
                    SCTPStream st = this.assoc.getStream(s4);
                    if (st == null) continue;
                    st.setClosing(true);
                }
                reply.addParam(rep);
                Log.debug("Ireset " + ireset);
            }
        }
        if (reply.hasParam()) {
            ret[0] = reply;
            Log.debug("about to reply with " + reply.toString());
        } else {
            ret = null;
        }
        return ret;
    }

    ReConfigChunk makeClose(SCTPStream st) throws Exception {
        ReConfigChunk ret = null;
        Log.debug("building reconfig so close stream " + st);
        st.setClosing(true);
        this.listOfStreamsToReset.add(st);
        if (!this.timerIsRunning()) {
            ret = this.makeSSNResets();
        }
        return ret;
    }

    private ReConfigChunk makeSSNResets() throws Exception {
        KnownParam rep;
        ReConfigChunk reply = new ReConfigChunk();
        Log.debug("closing streams n=" + this.listOfStreamsToReset.size());
        int[] streams = this.listOfStreamsToReset.stream().filter(s2 -> s2.InboundIsOpen()).mapToInt(s2 -> s2.getNum()).toArray();
        if (streams.length > 0) {
            rep = new OutgoingSSNResetRequestParameter(this.nextNearNo(), this.farSeqno - 1L, this.assoc.getNearTSN());
            ((OutgoingSSNResetRequestParameter)rep).setStreams(streams);
            reply.addParam(rep);
        }
        if ((streams = this.listOfStreamsToReset.stream().filter(s2 -> s2.OutboundIsOpen()).mapToInt(s2 -> s2.getNum()).toArray()).length > 0) {
            rep = new IncomingSSNResetRequestParameter(this.nextNearNo());
            ((IncomingSSNResetRequestParameter)rep).setStreams(streams);
            reply.addParam(rep);
        }
        Log.debug("reconfig chunk is " + reply.toString());
        return reply;
    }
}

