/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.behave;

import com.phono.srtplight.Log;
import java.util.SortedSet;
import pe.pi.sctp4j.sctp.AssociationListener;
import pe.pi.sctp4j.sctp.SCTPOutboundStreamOpenedListener;
import pe.pi.sctp4j.sctp.SCTPStream;
import pe.pi.sctp4j.sctp.SCTPStreamListener;
import pe.pi.sctp4j.sctp.behave.SCTPStreamBehaviour;
import pe.pi.sctp4j.sctp.dataChannel.DECP.DCOpen;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.DataChunk;

public class OldDCEPStreamBehaviour
implements SCTPStreamBehaviour {
    private final AssociationListener al;

    public OldDCEPStreamBehaviour(AssociationListener associationListener) {
        this.al = associationListener;
        Log.debug("DCEPStreamBehaviour");
    }

    @Override
    public Chunk[] respond(SCTPStream a) {
        return null;
    }

    @Override
    public void deliver(SCTPStream s2, SortedSet<DataChunk> a, SCTPStreamListener l) {
        DataChunk dc = a.first();
        int flags = dc.getFlags() & 3;
        long tsn = dc.getTsn();
        int messageNo = s2.getNextMessageSeqIn();
        DCOpen dcep = dc.getDCEP();
        if (dcep != null) {
            Log.debug("DCEPStreamBehaviour has a dcep first.");
            if (flags != 3) {
                Log.error("Dcep isn't a single !!?!");
            }
            s2.setNextMessageSeqIn(++messageNo);
            a.remove(dc);
            SCTPStreamBehaviour behave = dcep.mkStreamBehaviour();
            s2.setBehave(behave);
            if (!dcep.isAck()) {
                Log.debug("decp open  " + dcep.toString());
                s2.setLabel(dcep.getLabel());
                try {
                    s2.openAck(dcep);
                    this.al.onDCEPStream(s2, s2.getLabel(), dc.getPpid());
                }
                catch (Exception x) {
                    try {
                        s2.close();
                    }
                    catch (Exception sx) {
                        Log.error("Can't close " + s2.toString() + " because " + x.getMessage());
                    }
                }
            } else {
                Log.debug("got a dcep ack for " + s2.getLabel());
                if (l != null && l instanceof SCTPOutboundStreamOpenedListener) {
                    ((SCTPOutboundStreamOpenedListener)((Object)l)).opened(s2);
                }
            }
            if (behave != null) {
                behave.deliver(s2, a, l);
            }
        } else {
            Log.debug("Cant deliver chunks before DCEP");
        }
    }
}

