/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.behave;

import com.phono.srtplight.Log;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import pe.pi.sctp4j.sctp.SCTPMessage;
import pe.pi.sctp4j.sctp.SCTPStream;
import pe.pi.sctp4j.sctp.SCTPStreamListener;
import pe.pi.sctp4j.sctp.behave.SCTPStreamBehaviour;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.DataChunk;

public class OrderedStreamBehaviour
implements SCTPStreamBehaviour {
    protected boolean _ordered = true;

    @Override
    public void deliver(SCTPStream s2, SortedSet<DataChunk> stash, SCTPStreamListener l) {
        ArrayList<DataChunk> delivered = new ArrayList<DataChunk>();
        TreeSet<DataChunk> message = null;
        if (stash.isEmpty()) {
            return;
        }
        long expectedTsn = stash.first().getTsn();
        for (DataChunk dc : stash) {
            boolean lookingForOrderedMessages;
            int messageNo = s2.getNextMessageSeqIn();
            int flags = dc.getFlags() & 3;
            long tsn = dc.getTsn();
            boolean bl = lookingForOrderedMessages = this._ordered || message != null;
            if (lookingForOrderedMessages && tsn != expectedTsn) {
                Log.debug("Hole in chunk sequence  " + tsn + " expected " + expectedTsn);
                break;
            }
            switch (flags) {
                case 3: {
                    if (this._ordered && messageNo != dc.getSSeqNo()) {
                        Log.debug("Hole (single) in message sequence  " + dc.getSSeqNo() + " expected " + messageNo);
                        break;
                    }
                    SCTPMessage single = new SCTPMessage(s2, dc);
                    if (!single.deliver(l)) break;
                    delivered.add(dc);
                    s2.setNextMessageSeqIn(++messageNo);
                    break;
                }
                case 2: {
                    if (this._ordered && messageNo != dc.getSSeqNo()) {
                        Log.debug("Hole (begin) in message sequence  " + dc.getSSeqNo() + " expected " + messageNo);
                        break;
                    }
                    message = new TreeSet<DataChunk>();
                    message.add(dc);
                    Log.verb("new message no" + dc.getSSeqNo() + " starts with  " + dc.getTsn());
                    break;
                }
                case 0: {
                    if (message != null) {
                        message.add(dc);
                        Log.verb("continued message no" + dc.getSSeqNo() + " with  " + dc.getTsn());
                        break;
                    }
                    Log.debug("Middle with no start" + dc.getSSeqNo() + " tsn " + dc.getTsn());
                    break;
                }
                case 1: {
                    if (message != null) {
                        message.add(dc);
                        Log.verb("finished message no" + dc.getSSeqNo() + " with  " + dc.getTsn());
                        SCTPMessage deliverable = new SCTPMessage(s2, message);
                        if (deliverable.deliver(l)) {
                            delivered.addAll(message);
                            s2.setNextMessageSeqIn(++messageNo);
                        }
                        message = null;
                        break;
                    }
                    Log.debug("End with no start" + dc.getSSeqNo() + " tsn " + dc.getTsn());
                    message = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible value in stream logic");
                }
            }
            expectedTsn = tsn + 1L;
        }
        stash.removeAll(delivered);
    }

    @Override
    public Chunk[] respond(SCTPStream a) {
        return null;
    }
}

