/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.leakey;

import com.phono.srtplight.Log;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DatagramTransport;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

class LeakyTransport
implements DatagramTransport {
    DatagramTransport _dtls;
    DatagramSocket _logrec;
    DatagramSocket _logsend;
    static short SCTP = (short)9800;

    public LeakyTransport(DatagramTransport transport) {
        InetAddress me = Inet4Address.getLoopbackAddress();
        try {
            this._dtls = transport;
            this._logrec = new DatagramSocket(SCTP, me);
            this._logsend = new DatagramSocket(SCTP + 1, me);
            InetSocketAddress s2 = (InetSocketAddress)this._logsend.getLocalSocketAddress();
            Log.warn("Leaking to send address " + s2.getHostString() + ":" + s2.getPort());
            InetSocketAddress r = (InetSocketAddress)this._logrec.getLocalSocketAddress();
            Log.warn("Leaking to recv address " + r.getHostString() + ":" + r.getPort());
        }
        catch (Exception ex) {
            Log.error("exception in making Leaky socket " + SCTP + " loopback " + me);
        }
        SCTP = (short)(SCTP + 10);
    }

    @Override
    public int getReceiveLimit() throws IOException {
        return this._dtls.getReceiveLimit();
    }

    @Override
    public int getSendLimit() throws IOException {
        return this._dtls.getSendLimit();
    }

    @Override
    public int receive(byte[] bytes, int offs, int len, int sleep) throws IOException {
        int sz = this._dtls.receive(bytes, offs, len, sleep);
        if (sz > 0) {
            DatagramPacket p = new DatagramPacket(bytes, offs, sz, this._logsend.getLocalSocketAddress());
            this._logrec.send(p);
        }
        return sz;
    }

    @Override
    public void send(byte[] bytes, int offs, int len) throws IOException {
        if (bytes == null || bytes.length < offs + len || bytes.length < 1) {
            Log.error("Implausible packet for encryption ");
            if (bytes == null) {
                Log.error("null buffer");
            } else {
                Log.error("Length =" + bytes.length + " len =" + len + " offs=" + offs);
            }
            return;
        }
        try {
            DatagramPacket p = new DatagramPacket(bytes, offs, len, this._logrec.getLocalSocketAddress());
            this._logsend.send(p);
        }
        catch (Exception x) {
            Log.error("can't leak to " + this._logrec.getLocalSocketAddress());
            x.printStackTrace();
        }
        this._dtls.send(bytes, offs, len);
    }

    @Override
    public void close() throws IOException {
        this._dtls.close();
        this._logrec.close();
        this._logsend.close();
    }
}

