/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages;

import com.phono.srtplight.Log;
import java.nio.ByteBuffer;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.params.StateCookie;
import pe.pi.sctp4j.sctp.messages.params.VariableParam;

public class InitAckChunk
extends Chunk {
    int _initiateTag;
    long _adRecWinCredit;
    int _numOutStreams;
    int _numInStreams;
    long _initialTSN;
    private byte[] _cookie;
    private byte[] _supportedExtensions;

    public InitAckChunk() {
        super((byte)2);
    }

    public int getInitiateTag() {
        return this._initiateTag;
    }

    public void setInitiateTag(int v) {
        this._initiateTag = v;
    }

    public long getAdRecWinCredit() {
        return this._adRecWinCredit;
    }

    public void setAdRecWinCredit(int v) {
        this._adRecWinCredit = v;
    }

    public int getNumOutStreams() {
        return this._numOutStreams;
    }

    public void setNumOutStreams(int v) {
        this._numOutStreams = v;
    }

    public int getNumInStreams() {
        return this._numInStreams;
    }

    public void setNumInStreams(int v) {
        this._numInStreams = v;
    }

    public long getInitialTSN() {
        return this._initialTSN;
    }

    public void setInitialTSN(long v) {
        this._initialTSN = v;
    }

    public byte[] getCookie() {
        return this._cookie;
    }

    public void setCookie(byte[] v) {
        this._cookie = v;
    }

    public InitAckChunk(byte type, byte flags, int length, ByteBuffer pkt) {
        super(type, flags, length, pkt);
        if (this._body.remaining() >= 16) {
            this._initiateTag = this._body.getInt();
            this._adRecWinCredit = InitAckChunk.getUnsignedInt(this._body);
            this._numOutStreams = this._body.getChar();
            this._numInStreams = this._body.getChar();
            this._initialTSN = InitAckChunk.getUnsignedInt(this._body);
            Log.verb("Init Ack" + this.toString());
            while (this._body.hasRemaining()) {
                VariableParam v = this.readVariable();
                this._varList.add(v);
            }
            for (VariableParam v : this._varList) {
                Log.verb("variable of type: " + v.getName() + " " + v.toString());
                if (v instanceof StateCookie) {
                    this._cookie = ((StateCookie)v).getData();
                    continue;
                }
                Log.verb("ignored variable of type: " + v.getName());
            }
        }
    }

    @Override
    public String toString() {
        Object ret = super.toString();
        ret = (String)ret + " initiateTag : " + this._initiateTag + " adRecWinCredit : " + this._adRecWinCredit + " numOutStreams : " + this._numOutStreams + " numInStreams : " + this._numInStreams + " initialTSN : " + this._initialTSN + (String)(this._supportedExtensions == null ? " no supported extensions" : " supported extensions are: " + InitAckChunk.chunksToNames(this._supportedExtensions));
        return ret;
    }

    @Override
    void putFixedParams(ByteBuffer ret) {
        ret.putInt(this._initiateTag);
        InitAckChunk.putUnsignedInt(ret, this._adRecWinCredit);
        ret.putChar((char)this._numOutStreams);
        ret.putChar((char)this._numInStreams);
        InitAckChunk.putUnsignedInt(ret, this._initialTSN);
        if (this._cookie != null) {
            StateCookie sc = new StateCookie();
            sc.setData(this._cookie);
            this._varList.add(sc);
        }
        if (this._supportedExtensions != null) {
            Chunk.SupportedExtensions se = new Chunk.SupportedExtensions();
            se.setData(this._supportedExtensions);
            this._varList.add(se);
        }
    }

    public byte[] getSupportedExtensions(byte[] v) {
        return this._supportedExtensions;
    }

    public void setSupportedExtensions(byte[] v) {
        this._supportedExtensions = v;
    }
}

