/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages;

import com.phono.srtplight.Log;
import java.nio.ByteBuffer;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.params.AddIncomingStreamsRequestParameter;
import pe.pi.sctp4j.sctp.messages.params.AddOutgoingStreamsRequestParameter;
import pe.pi.sctp4j.sctp.messages.params.IncomingSSNResetRequestParameter;
import pe.pi.sctp4j.sctp.messages.params.OutgoingSSNResetRequestParameter;
import pe.pi.sctp4j.sctp.messages.params.ReconfigurationResponseParameter;
import pe.pi.sctp4j.sctp.messages.params.VariableParam;

public class ReConfigChunk
extends Chunk {
    private long sentAt;
    private int retries;

    public ReConfigChunk(byte type, byte flags, int length, ByteBuffer pkt) {
        super(type, flags, length, pkt);
        Log.debug("ReConfig chunk" + this.toString());
        if (this._body.remaining() >= 4) {
            while (this._body.hasRemaining()) {
                VariableParam v = this.readVariable();
                this._varList.add(v);
                Log.debug("\tParam :" + v.toString());
            }
        }
    }

    public ReConfigChunk() {
        super((byte)-126);
    }

    @Override
    void putFixedParams(ByteBuffer ret) {
    }

    public boolean hasIncomingReset() {
        return this._varList.stream().anyMatch(v -> v instanceof IncomingSSNResetRequestParameter);
    }

    public IncomingSSNResetRequestParameter getIncomingReset() {
        return this._varList.stream().filter(v -> v instanceof IncomingSSNResetRequestParameter).map(v -> (IncomingSSNResetRequestParameter)v).findFirst().orElse(null);
    }

    public boolean hasOutgoingReset() {
        return this._varList.stream().anyMatch(v -> v instanceof OutgoingSSNResetRequestParameter);
    }

    private boolean hasOutgoingAdd() {
        return this._varList.stream().anyMatch(v -> v instanceof AddOutgoingStreamsRequestParameter);
    }

    private boolean hasResponse() {
        return this._varList.stream().anyMatch(v -> v instanceof ReconfigurationResponseParameter);
    }

    public OutgoingSSNResetRequestParameter getOutgoingReset() {
        return this._varList.stream().filter(v -> v instanceof OutgoingSSNResetRequestParameter).map(v -> (OutgoingSSNResetRequestParameter)v).findFirst().orElse(null);
    }

    public boolean hasParam() {
        return !this._varList.isEmpty();
    }

    @Override
    public void validate() {
        if (this._varList.size() < 1) {
            throw new IllegalArgumentException("Too few params " + this._varList.size());
        }
        if (this._varList.size() > 2) {
            throw new IllegalArgumentException("Too many params " + this._varList.size());
        }
        if (this._varList.size() == 2) {
            VariableParam remain;
            if (this.hasOutgoingReset()) {
                VariableParam remain2 = this._varList.stream().filter(v -> !(v instanceof OutgoingSSNResetRequestParameter)).findFirst().orElse(null);
                if (remain2 == null) {
                    throw new IllegalArgumentException("2 OutgoingSSNResetRequestParameter in one Chunk not allowed ");
                }
                if (!(remain2 instanceof IncomingSSNResetRequestParameter) && !(remain2 instanceof ReconfigurationResponseParameter)) {
                    throw new IllegalArgumentException("OutgoingSSNResetRequestParameter and " + remain2.getClass().getSimpleName() + " in same Chunk not allowed ");
                }
            } else if (this.hasOutgoingAdd()) {
                VariableParam remain3 = this._varList.stream().filter(v -> !(v instanceof AddOutgoingStreamsRequestParameter)).findFirst().orElse(null);
                if (remain3 == null) {
                    throw new IllegalArgumentException("2 AddOutgoingStreamsRequestParameter in one Chunk not allowed ");
                }
                if (!(remain3 instanceof AddIncomingStreamsRequestParameter)) {
                    throw new IllegalArgumentException("OutgoingSSNResetRequestParameter and " + remain3.getClass().getSimpleName() + " in same Chunk not allowed ");
                }
            } else if (this.hasResponse() && (remain = (VariableParam)this._varList.stream().filter(v -> !(v instanceof ReconfigurationResponseParameter)).findFirst().orElse(null)) != null) {
                throw new IllegalArgumentException("ReconfigurationResponseParameter and " + remain.getClass().getSimpleName() + " in same Chunk not allowed ");
            }
        }
    }

    public void addParam(VariableParam rep) {
        Log.debug("adding " + rep + " to " + this);
        this._varList.add(rep);
        this.validate();
    }

    public boolean sameAs(ReConfigChunk other) {
        boolean ret = false;
        if (other != null) {
            if (this.hasIncomingReset() && other.hasIncomingReset() && this.hasOutgoingReset() && other.hasOutgoingReset()) {
                ret = this.getIncomingReset().sameAs(other.getIncomingReset()) && this.getOutgoingReset().sameAs(other.getOutgoingReset());
            } else {
                if (this.hasIncomingReset() && other.hasIncomingReset()) {
                    ret = this.getIncomingReset().sameAs(other.getIncomingReset());
                }
                if (this.hasOutgoingReset() && other.hasOutgoingReset()) {
                    ret = this.getOutgoingReset().sameAs(other.getOutgoingReset());
                }
            }
        }
        return ret;
    }

    public long getSentTime() {
        return this.sentAt;
    }

    public void setSentTime(long now) {
        this.sentAt = now;
    }

    public int getAndIncrementRetryCount() {
        return this.retries++;
    }
}

