/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages.params;

import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import pe.pi.sctp4j.sctp.messages.exceptions.SctpPacketFormatException;
import pe.pi.sctp4j.sctp.messages.params.KnownParam;

public class IPv6Address
extends KnownParam {
    Inet6Address addr;

    public IPv6Address(int t, String n) {
        super(t, n);
    }

    @Override
    public void readBody(ByteBuffer body, int blen) throws SctpPacketFormatException {
        byte[] data = new byte[blen];
        body.get(data);
        try {
            this.addr = (Inet6Address)Inet6Address.getByAddress(data);
        }
        catch (UnknownHostException ex) {
            throw new SctpPacketFormatException(ex.getMessage());
        }
    }

    @Override
    public void writeBody(ByteBuffer body) throws SctpPacketFormatException {
        body.put(this.addr.getAddress());
    }
}

