/*
 * Decompiled with CFR 0.152.
 */
package com.nikoverflow.exploitpreventer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigManager {
    private final File file;
    private final Gson gson;
    private JsonObject config;

    public ConfigManager(File file) {
        this.file = file;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            JsonElement jsonElement = JsonParser.parseReader((Reader)new FileReader(file));
            this.config = jsonElement.getAsJsonObject();
        }
        catch (JsonSyntaxException | FileNotFoundException e) {
            this.config = new JsonObject();
        }
    }

    public void set(String key, JsonElement value) {
        if (key.startsWith(".") || key.endsWith(".")) {
            throw new IllegalArgumentException("Key cannot start or end with '.'!");
        }
        String[] parts = key.split("\\.");
        JsonObject current = this.config;
        for (int i = 0; i < parts.length - 1; ++i) {
            if (!current.has(parts[i]) || !current.get(parts[i]).isJsonObject()) {
                current.add(parts[i], (JsonElement)new JsonObject());
            }
            current = current.getAsJsonObject(parts[i]);
        }
        current.add(parts[parts.length - 1], value);
    }

    public JsonElement get(String key) {
        if (key.startsWith(".") || key.endsWith(".")) {
            throw new IllegalArgumentException("Key cannot start or end with '.'!");
        }
        String[] parts = key.split("\\.");
        JsonObject current = this.config;
        for (int i = 0; i < parts.length - 1; ++i) {
            if (!current.has(parts[i]) || !current.get(parts[i]).isJsonObject()) {
                return new JsonObject();
            }
            current = current.getAsJsonObject(parts[i]);
        }
        return current.get(parts[parts.length - 1]);
    }

    public void save() throws IOException {
        if (this.file.getParentFile() != null) {
            this.file.getParentFile().mkdirs();
        }
        this.file.createNewFile();
        FileWriter fileWriter = new FileWriter(this.file);
        fileWriter.write(String.valueOf(this.gson.toJson((JsonElement)this.config)));
        fileWriter.close();
    }
}

