/*
 * Decompiled with CFR 0.152.
 */
package com.nikoverflow.exploitpreventer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModDependency;

public class Utils {
    public static String getModIdFromPath(Path path) throws IOException {
        String modId = null;
        if (path.endsWith("build/classes/java/main/")) {
            FileInputStream inputStream = new FileInputStream(path.resolve("../../../resources/main/fabric.mod.json").toFile());
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            JsonObject jsonObject = JsonParser.parseReader((Reader)inputStreamReader).getAsJsonObject();
            inputStreamReader.close();
            ((InputStream)inputStream).close();
            modId = jsonObject.get("id").getAsString();
        } else {
            try (JarFile jarFile = new JarFile(path.toFile());){
                JarEntry jarEntry = jarFile.getJarEntry("fabric.mod.json");
                if (jarEntry != null) {
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    JsonObject jsonObject = JsonParser.parseReader((Reader)inputStreamReader).getAsJsonObject();
                    inputStreamReader.close();
                    inputStream.close();
                    String string = jsonObject.get("id").getAsString();
                    return string;
                }
            }
        }
        return modId;
    }

    public static String getModIdFromClass(Class<?> clazz) {
        if (clazz.getProtectionDomain().getCodeSource() == null) {
            return null;
        }
        try {
            Path path = Path.of(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
            return Utils.getModIdFromPath(path);
        }
        catch (IOException | URISyntaxException exception) {
            return null;
        }
    }

    public static String getModIdFromStacktrace() {
        StackTraceElement[] stackTraceElements;
        for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
            if (stackTraceElement.getClassName().equals(Thread.class.getName()) || stackTraceElement.getClassName().equals(Utils.class.getName()) || stackTraceElement.getClassName().startsWith("net.fabricmc.fabric.")) continue;
            try {
                return Utils.getModIdFromClass(Class.forName(stackTraceElement.getClassName()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Set<String> findAllDependenciesFromMod(String mod) {
        HashSet<String> dependencies = new HashSet<String>();
        Optional optionalMod = FabricLoader.getInstance().getModContainer(mod);
        if (optionalMod.isEmpty()) {
            return dependencies;
        }
        ArrayDeque<String> stack = new ArrayDeque<String>();
        stack.push(mod);
        while (!stack.isEmpty()) {
            Optional currentMod;
            String currentModId = (String)stack.pop();
            if (!dependencies.add(currentModId) || (currentMod = FabricLoader.getInstance().getModContainer(currentModId)).isEmpty()) continue;
            for (ModDependency dependency : ((ModContainer)currentMod.get()).getMetadata().getDependencies()) {
                if (dependency.getKind().equals((Object)ModDependency.Kind.BREAKS) || dependencies.contains(dependency.getModId())) continue;
                stack.add(dependency.getModId());
            }
        }
        dependencies.remove(mod);
        dependencies.remove("minecraft");
        dependencies.remove("java");
        return dependencies;
    }

    public static boolean isLocalAddress(String host) throws UnknownHostException {
        if (host == null) {
            return false;
        }
        for (InetAddress address : InetAddress.getAllByName(host)) {
            if (!address.isAnyLocalAddress() && !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isLinkLocalAddress()) continue;
            return true;
        }
        return false;
    }
}

