/*
 * Decompiled with CFR 0.152.
 */
package com.nikoverflow.exploitpreventer.injection.mixin.vanilla;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.nikoverflow.exploitpreventer.GlobalState;
import com.nikoverflow.exploitpreventer.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_3521;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_3521.class})
public class HttpUtilMixin {
    @WrapOperation(method={"downloadFile"}, at={@At(value="INVOKE", target="Ljava/net/HttpURLConnection;getInputStream()Ljava/io/InputStream;")})
    private static InputStream ep$downloadFile(HttpURLConnection instance, Operation<InputStream> original, @Local(argsOnly=true) Proxy proxy, @Local(argsOnly=true) Map<String, String> requestProperties, @Local LocalRef<HttpURLConnection> httpURLConnection) throws IOException {
        if (GlobalState.DRY_RUN) {
            return (InputStream)original.call(new Object[]{instance});
        }
        if (!Utils.isLocalAddress(GlobalState.serverAddress) && Utils.isLocalAddress(instance.getURL().getHost())) {
            throw new IllegalStateException("Tried to connect to local address!");
        }
        instance.setInstanceFollowRedirects(false);
        int redirects = 0;
        String maxRedirectString = System.getProperty("http.maxRedirects") == null ? "20" : System.getProperty("http.maxRedirects");
        int maxRedirects = 20;
        try {
            maxRedirects = Math.max(Integer.parseInt(maxRedirectString), 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int status = instance.getResponseCode();
        while (instance.getHeaderField("Location") != null && (status > 299 && status < 304 || status == 305 || status == 307)) {
            URL url;
            if (redirects > maxRedirects - 1) {
                throw new ProtocolException("Server redirected too many times (" + maxRedirects + ")");
            }
            try {
                url = new URL(instance.getHeaderField("Location"));
                if (!instance.getURL().getProtocol().equalsIgnoreCase(url.getProtocol())) {
                    break;
                }
            }
            catch (MalformedURLException exception) {
                url = new URL(instance.getURL(), instance.getHeaderField("Location"));
            }
            instance = (HttpURLConnection)url.openConnection(proxy);
            instance.setInstanceFollowRedirects(false);
            Objects.requireNonNull(instance);
            requestProperties.forEach(instance::setRequestProperty);
            if (!Utils.isLocalAddress(GlobalState.serverAddress) && Utils.isLocalAddress(instance.getURL().getHost())) {
                throw new IllegalStateException("Tried to connect to local address!");
            }
            status = instance.getResponseCode();
            ++redirects;
        }
        if (redirects > maxRedirects - 1) {
            throw new ProtocolException("Server redirected too many times (" + maxRedirects + ")");
        }
        httpURLConnection.set((Object)instance);
        return (InputStream)original.call(new Object[]{instance});
    }
}

