/*
 * Decompiled with CFR 0.152.
 */
package com.nikoverflow.exploitpreventer.injection.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_3521;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_3521.class})
public class HttpUtilMixin {
    @WrapOperation(method={"downloadFile"}, at={@At(value="INVOKE", target="Ljava/net/HttpURLConnection;getInputStream()Ljava/io/InputStream;")})
    private static InputStream ep$downloadFile(HttpURLConnection instance, Operation<InputStream> original, @Local(argsOnly=true) Proxy proxy, @Local(argsOnly=true) Map<String, String> requestProperties, @Local LocalRef<HttpURLConnection> httpURLConnection) throws IOException, URISyntaxException {
        InetAddress[] addresses;
        for (InetAddress address : addresses = InetAddress.getAllByName(instance.getURL().getHost())) {
            if (!address.isAnyLocalAddress() && !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isLinkLocalAddress()) continue;
            throw new IllegalStateException("Tried to connect to local address!");
        }
        instance.setInstanceFollowRedirects(false);
        int status = instance.getResponseCode();
        int redirects = 0;
        String maxRedirectString = System.getProperty("http.maxRedirects") == null ? "20" : System.getProperty("http.maxRedirects");
        int maxRedirects = 20;
        try {
            maxRedirects = Math.max(Integer.parseInt(maxRedirectString), 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        while (status > 299 && status < 400) {
            if (redirects > maxRedirects - 1) {
                throw new ProtocolException("Server redirected too many times (" + maxRedirects + ")");
            }
            instance = (HttpURLConnection)instance.getURL().toURI().resolve(instance.getHeaderField("Location")).toURL().openConnection(proxy);
            instance.setInstanceFollowRedirects(false);
            Objects.requireNonNull(instance);
            requestProperties.forEach(instance::setRequestProperty);
            for (InetAddress address : addresses = InetAddress.getAllByName(instance.getURL().getHost())) {
                if (!address.isAnyLocalAddress() && !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isLinkLocalAddress()) continue;
                throw new IllegalStateException("Tried to connect to local address!");
            }
            status = instance.getResponseCode();
            ++redirects;
        }
        if (redirects > maxRedirects - 1) {
            throw new ProtocolException("Server redirected too many times (" + maxRedirects + ")");
        }
        httpURLConnection.set((Object)instance);
        return (InputStream)original.call(new Object[]{instance});
    }
}

