/*
 * Decompiled with CFR 0.152.
 */
package com.nikoverflow.exploitpreventer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModDependency;

public class Utils {
    public static String getModIdFromJar(File file) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            JarEntry jarEntry = jarFile.getJarEntry("fabric.mod.json");
            if (jarEntry != null) {
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                JsonObject jsonObject = JsonParser.parseReader((Reader)inputStreamReader).getAsJsonObject();
                inputStreamReader.close();
                inputStream.close();
                String string = jsonObject.get("id").getAsString();
                return string;
            }
        }
        return null;
    }

    public static Set<String> findAllDependenciesFromMod(String mod) {
        HashSet<String> dependencies = new HashSet<String>();
        Optional optionalMod = FabricLoader.getInstance().getModContainer(mod);
        if (optionalMod.isEmpty()) {
            return dependencies;
        }
        ArrayDeque<String> stack = new ArrayDeque<String>();
        stack.push(mod);
        while (!stack.isEmpty()) {
            Optional currentMod;
            String currentModId = (String)stack.pop();
            if (!dependencies.add(currentModId) || (currentMod = FabricLoader.getInstance().getModContainer(currentModId)).isEmpty()) continue;
            for (ModDependency dependency : ((ModContainer)currentMod.get()).getMetadata().getDependencies()) {
                if (dependencies.contains(dependency.getModId())) continue;
                stack.add(dependency.getModId());
            }
        }
        dependencies.remove(mod);
        dependencies.remove("minecraft");
        dependencies.remove("java");
        dependencies.remove("fabricloader");
        return dependencies;
    }

    public static boolean isLocalAddress(String host) throws UnknownHostException {
        if (host == null) {
            return false;
        }
        for (InetAddress address : InetAddress.getAllByName(host)) {
            if (!address.isAnyLocalAddress() && !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isLinkLocalAddress()) continue;
            return true;
        }
        return false;
    }
}

