/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.time.Instant;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.util.gson.JObject;
import net.luckperms.api.actionlog.Action;

public final class ActionJsonSerializer {
    private ActionJsonSerializer() {
    }

    public static JsonObject serialize(Action logEntry) {
        return new JObject().add("timestamp", (JsonElement)new JsonPrimitive((Number)logEntry.getTimestamp().getEpochSecond())).add("source", new JObject().add("uniqueId", (JsonElement)new JsonPrimitive(logEntry.getSource().getUniqueId().toString())).add("name", (JsonElement)new JsonPrimitive(logEntry.getSource().getName()))).add("target", new JObject().add("type", (JsonElement)new JsonPrimitive(logEntry.getTarget().getType().name())).consume(obj -> {
            if (logEntry.getTarget().getUniqueId().isPresent()) {
                obj.add("uniqueId", (JsonElement)new JsonPrimitive(logEntry.getTarget().getUniqueId().get().toString()));
            }
        }).add("name", (JsonElement)new JsonPrimitive(logEntry.getTarget().getName()))).add("description", (JsonElement)new JsonPrimitive(logEntry.getDescription())).toJson();
    }

    public static LoggedAction deserialize(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject data = element.getAsJsonObject();
        LoggedAction.Builder builder = LoggedAction.build();
        if (data.has("timestamp")) {
            builder.timestamp(Instant.ofEpochSecond(data.get("timestamp").getAsLong()));
        }
        if (data.has("source")) {
            JsonObject source = data.get("source").getAsJsonObject();
            builder.source(UUID.fromString(source.get("uniqueId").getAsString()));
            builder.sourceName(source.get("name").getAsString());
        } else {
            builder.source(UUID.fromString(data.get("actor").getAsString()));
            builder.sourceName(data.get("actorName").getAsString());
        }
        if (data.has("target")) {
            JsonObject target = data.get("target").getAsJsonObject();
            builder.targetType(LoggedAction.parseType(target.get("type").getAsString()));
            if (target.has("uniqueId")) {
                builder.target(UUID.fromString(target.get("uniqueId").getAsString()));
            }
            builder.targetName(target.get("name").getAsString());
        } else {
            builder.targetType(LoggedAction.parseType(data.get("type").getAsString()));
            if (data.has("acted")) {
                builder.target(UUID.fromString(data.get("acted").getAsString()));
            }
            builder.targetName(data.get("actedName").getAsString());
        }
        if (data.has("description")) {
            builder.description(data.get("description").getAsString());
        } else {
            builder.description(data.get("action").getAsString());
        }
        return builder.build();
    }
}

