/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.commands.log.LogNotify;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.messaging.InternalMessagingService;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import net.luckperms.api.event.log.LogBroadcastEvent;
import net.luckperms.api.event.log.LogNotifyEvent;

public class LogDispatcher {
    private final LuckPermsPlugin plugin;

    public LogDispatcher(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    private boolean shouldBroadcast(LoggedAction entry, LogBroadcastEvent.Origin origin) {
        boolean cancelled = false;
        if (!this.plugin.getConfiguration().get(ConfigKeys.LOG_NOTIFY).booleanValue()) {
            cancelled = true;
        } else if (origin == LogBroadcastEvent.Origin.REMOTE && !this.plugin.getConfiguration().get(ConfigKeys.BROADCAST_RECEIVED_LOG_ENTRIES).booleanValue()) {
            cancelled = true;
        } else {
            Collection filters = this.plugin.getConfiguration().get(ConfigKeys.LOG_NOTIFY_FILTERED_DESCRIPTIONS);
            for (Pattern filter : filters) {
                if (!filter.matcher(entry.getDescription()).matches()) continue;
                cancelled = true;
                break;
            }
        }
        return !this.plugin.getEventDispatcher().dispatchLogBroadcast(cancelled, entry, origin);
    }

    private void broadcast(LoggedAction entry, LogBroadcastEvent.Origin broadcastOrigin, LogNotifyEvent.Origin origin, Sender sender) {
        if (!this.shouldBroadcast(entry, broadcastOrigin)) {
            return;
        }
        this.plugin.getOnlineSenders().filter(CommandPermission.LOG_NOTIFY::isAuthorized).filter(s -> {
            boolean shouldCancel = LogNotify.isIgnoring(this.plugin, s.getUniqueId()) || sender != null && s.getUniqueId().equals(sender.getUniqueId());
            return !this.plugin.getEventDispatcher().dispatchLogNotify(shouldCancel, entry, origin, (Sender)s);
        }).forEach(s -> Message.LOG.send((Sender)s, entry));
    }

    public CompletableFuture<Void> logToStorage(LoggedAction entry) {
        if (!this.plugin.getEventDispatcher().dispatchLogPublish(false, entry)) {
            return this.plugin.getStorage().logAction(entry);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> logToMessaging(LoggedAction entry) {
        InternalMessagingService messagingService = this.plugin.getMessagingService().orElse(null);
        if (messagingService != null) {
            return messagingService.pushLog(entry);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> dispatch(LoggedAction entry, Sender sender, LogBroadcastEvent.Origin broadcastOrigin, LogNotifyEvent.Origin origin) {
        CompletableFuture<Void> storageFuture = this.logToStorage(entry);
        CompletableFuture<Void> messagingFuture = this.logToMessaging(entry);
        this.broadcast(entry, broadcastOrigin, origin, sender);
        return CompletableFuture.allOf(storageFuture, messagingFuture);
    }

    public CompletableFuture<Void> dispatch(LoggedAction entry, Sender sender) {
        return this.dispatch(entry, sender, LogBroadcastEvent.Origin.LOCAL, LogNotifyEvent.Origin.LOCAL);
    }

    public CompletableFuture<Void> dispatchFromApi(LoggedAction entry) {
        return this.dispatch(entry, null, LogBroadcastEvent.Origin.LOCAL_API, LogNotifyEvent.Origin.LOCAL_API);
    }

    public void broadcastFromApi(LoggedAction entry) {
        this.broadcast(entry, LogBroadcastEvent.Origin.LOCAL_API, LogNotifyEvent.Origin.LOCAL_API, null);
    }

    public void broadcastFromRemote(LoggedAction entry) {
        this.broadcast(entry, LogBroadcastEvent.Origin.REMOTE, LogNotifyEvent.Origin.REMOTE, null);
    }
}

