/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.OptionalInt;
import me.lucko.luckperms.common.api.implementation.ApiPermissionHolder;
import me.lucko.luckperms.common.cacheddata.GroupCachedDataManager;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ApiGroup
extends ApiPermissionHolder
implements Group {
    private final me.lucko.luckperms.common.model.Group handle;

    public static me.lucko.luckperms.common.model.Group cast(Group group) {
        Objects.requireNonNull(group, "group");
        Preconditions.checkState((boolean)(group instanceof ApiGroup), (Object)("Illegal instance " + String.valueOf(group.getClass()) + " cannot be handled by this implementation."));
        return ((ApiGroup)group).getHandle();
    }

    public ApiGroup(me.lucko.luckperms.common.model.Group handle) {
        super(handle);
        this.handle = handle;
    }

    @Override
    me.lucko.luckperms.common.model.Group getHandle() {
        return this.handle;
    }

    @Override
    public @NonNull String getName() {
        return this.handle.getName();
    }

    @Override
    public @Nullable String getDisplayName() {
        return this.handle.getDisplayName().orElse(null);
    }

    @Override
    public @Nullable String getDisplayName(@NonNull QueryOptions queryOptions) {
        return this.handle.calculateDisplayName(queryOptions).orElse(null);
    }

    @Override
    public @NonNull OptionalInt getWeight() {
        return this.handle.getWeight();
    }

    @Override
    public @NonNull GroupCachedDataManager getCachedData() {
        return this.handle.getCachedData();
    }

    @Override
    protected void onNodeChange() {
        this.handle.getPlugin().getGroupManager().invalidateAllGroupCaches();
        this.handle.getPlugin().getUserManager().invalidateAllUserCaches();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiGroup)) {
            return false;
        }
        ApiGroup that = (ApiGroup)o;
        return this.handle.equals(that.handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }
}

