/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.lucko.luckperms.common.cacheddata.metastack.SimpleMetaStackDefinition;
import me.lucko.luckperms.common.cacheddata.metastack.StandardStackElements;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.metastacking.DuplicateRemovalFunction;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.metastacking.MetaStackElement;
import net.luckperms.api.metastacking.MetaStackFactory;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiMetaStackFactory
implements MetaStackFactory {
    public final LuckPermsPlugin plugin;

    public ApiMetaStackFactory(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public @NonNull Optional<MetaStackElement> fromString(@NonNull String definition) {
        Objects.requireNonNull(definition, "definition");
        return Optional.ofNullable(StandardStackElements.parseFromString(this.plugin, definition));
    }

    @Override
    public @NonNull List<MetaStackElement> fromStrings(@NonNull List<String> definitions) {
        Objects.requireNonNull(definitions, "definitions");
        if (definitions.isEmpty()) {
            return ImmutableList.of();
        }
        return StandardStackElements.parseList(this.plugin, definitions);
    }

    @Override
    public @NonNull MetaStackDefinition createDefinition(@NonNull List<MetaStackElement> elements, @NonNull DuplicateRemovalFunction duplicateRemovalFunction, @NonNull String startSpacer, @NonNull String middleSpacer, @NonNull String endSpacer) {
        return new SimpleMetaStackDefinition(elements, duplicateRemovalFunction, startSpacer, middleSpacer, endSpacer);
    }
}

