/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import java.util.Objects;
import me.lucko.luckperms.common.context.manager.ContextManager;
import me.lucko.luckperms.common.model.manager.user.UserManager;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.user.User;
import net.luckperms.api.platform.PlayerAdapter;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiPlayerAdapter<S, P extends S>
implements PlayerAdapter<P> {
    private final UserManager<?> userManager;
    private final ContextManager<S, P> contextManager;

    public ApiPlayerAdapter(UserManager<?> userManager, ContextManager<S, P> contextManager) {
        this.userManager = userManager;
        this.contextManager = contextManager;
    }

    private P checkType(P player) {
        if (!this.contextManager.getPlayerClass().isAssignableFrom(player.getClass())) {
            throw new IllegalStateException("Player class " + String.valueOf(player.getClass()) + " is not assignable from " + String.valueOf(this.contextManager.getPlayerClass()));
        }
        return player;
    }

    @Override
    public @NonNull User getUser(@NonNull P player) {
        Objects.requireNonNull(player, "player");
        me.lucko.luckperms.common.model.User user = (me.lucko.luckperms.common.model.User)this.userManager.getIfLoaded(this.contextManager.getUniqueId(this.checkType(player)));
        if (user == null) {
            throw new IllegalStateException("Unable to get a user for " + String.valueOf(player));
        }
        return user.getApiProxy();
    }

    @Override
    public @NonNull ImmutableContextSet getContext(@NonNull P player) {
        Objects.requireNonNull(player, "player");
        return this.contextManager.getContext(this.checkType(player));
    }

    @Override
    public @NonNull QueryOptions getQueryOptions(@NonNull P player) {
        Objects.requireNonNull(player, "player");
        return this.contextManager.getQueryOptions(this.checkType(player));
    }
}

