/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.bulkupdate.BulkUpdateField;
import me.lucko.luckperms.common.bulkupdate.DataType;
import me.lucko.luckperms.common.bulkupdate.action.BulkUpdateAction;
import me.lucko.luckperms.common.filter.Comparison;
import me.lucko.luckperms.common.filter.ConstraintFactory;
import me.lucko.luckperms.common.filter.Filter;
import me.lucko.luckperms.common.filter.FilterList;
import net.luckperms.api.node.Node;

public class BulkUpdateBuilder {
    private DataType dataType = DataType.ALL;
    private BulkUpdateAction action = null;
    private boolean trackStatistics = false;
    private final Set<Filter<Node, String>> filters = new LinkedHashSet<Filter<Node, String>>();

    public static BulkUpdateBuilder create() {
        return new BulkUpdateBuilder();
    }

    private BulkUpdateBuilder() {
    }

    public BulkUpdateBuilder action(BulkUpdateAction action) {
        this.action = action;
        return this;
    }

    public BulkUpdateBuilder dataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public BulkUpdateBuilder trackStatistics(boolean trackStatistics) {
        this.trackStatistics = trackStatistics;
        return this;
    }

    public BulkUpdateBuilder filter(BulkUpdateField field, Comparison comparison, String value) {
        this.filters.add(new Filter<Node, String>(field, ConstraintFactory.STRINGS.build(comparison, value)));
        return this;
    }

    public BulkUpdate build() {
        if (this.action == null) {
            throw new IllegalStateException("no action specified");
        }
        FilterList<Node> filters = new FilterList<Node>(FilterList.LogicalOperator.AND, (List<Filter<Node, ?>>)ImmutableList.copyOf(this.filters));
        return new BulkUpdate(this.dataType, this.action, filters, this.trackStatistics);
    }

    public String toString() {
        return "BulkUpdateBuilder(dataType=" + String.valueOf((Object)this.dataType) + ", action=" + String.valueOf(this.action) + ", constraints=" + String.valueOf(this.filters) + ", trackStatistics=" + this.trackStatistics + ")";
    }
}

