/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.metastack;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.lucko.luckperms.common.cacheddata.metastack.FluentMetaStackElement;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import net.luckperms.api.metastacking.MetaStackElement;
import net.luckperms.api.model.PermissionHolder;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.metadata.types.InheritanceOriginMetadata;
import net.luckperms.api.node.types.ChatMetaNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StandardStackElements {
    private static final MetaStackElement TYPE_CHECK = (type, node, current) -> type.nodeType().matches(node);
    private static final MetaStackElement HIGHEST_CHECK = (type, node, current) -> current == null || node.getPriority() > current.getPriority();
    private static final MetaStackElement LOWEST_CHECK = (type, node, current) -> current == null || node.getPriority() < current.getPriority();
    private static final MetaStackElement OWN_CHECK = (type, node, current) -> node.metadata(InheritanceOriginMetadata.KEY).getOrigin().getType().equals("user");
    private static final MetaStackElement INHERITED_CHECK = (type, node, current) -> node.metadata(InheritanceOriginMetadata.KEY).getOrigin().getType().equals("group");
    public static final MetaStackElement HIGHEST = FluentMetaStackElement.builder("HighestPriority").with(TYPE_CHECK).with(HIGHEST_CHECK).build();
    public static final MetaStackElement HIGHEST_OWN = FluentMetaStackElement.builder("HighestPriorityOwn").with(TYPE_CHECK).with(OWN_CHECK).with(HIGHEST_CHECK).build();
    public static final MetaStackElement HIGHEST_INHERITED = FluentMetaStackElement.builder("HighestPriorityInherited").with(TYPE_CHECK).with(INHERITED_CHECK).with(HIGHEST_CHECK).build();
    public static final MetaStackElement LOWEST = FluentMetaStackElement.builder("LowestPriority").with(TYPE_CHECK).with(LOWEST_CHECK).build();
    public static final MetaStackElement LOWEST_OWN = FluentMetaStackElement.builder("LowestPriorityOwn").with(TYPE_CHECK).with(OWN_CHECK).with(LOWEST_CHECK).build();
    public static final MetaStackElement LOWEST_INHERITED = FluentMetaStackElement.builder("LowestPriorityInherited").with(TYPE_CHECK).with(INHERITED_CHECK).with(LOWEST_CHECK).build();

    private StandardStackElements() {
    }

    public static MetaStackElement parseFromString(LuckPermsPlugin plugin, String s) {
        if ((s = s.toLowerCase(Locale.ROOT)).equals("highest")) {
            return HIGHEST;
        }
        if (s.equals("lowest")) {
            return LOWEST;
        }
        if (s.equals("highest_own")) {
            return HIGHEST_OWN;
        }
        if (s.equals("lowest_own")) {
            return LOWEST_OWN;
        }
        if (s.equals("highest_inherited")) {
            return HIGHEST_INHERITED;
        }
        if (s.equals("lowest_inherited")) {
            return LOWEST_INHERITED;
        }
        String p = StandardStackElements.parseParam(s, "highest_on_track_");
        if (p != null) {
            return StandardStackElements.highestFromGroupOnTrack(plugin, p);
        }
        p = StandardStackElements.parseParam(s, "lowest_on_track_");
        if (p != null) {
            return StandardStackElements.lowestFromGroupOnTrack(plugin, p);
        }
        p = StandardStackElements.parseParam(s, "highest_not_on_track_");
        if (p != null) {
            return StandardStackElements.highestNotFromGroupOnTrack(plugin, p);
        }
        p = StandardStackElements.parseParam(s, "lowest_not_on_track_");
        if (p != null) {
            return StandardStackElements.lowestNotFromGroupOnTrack(plugin, p);
        }
        p = StandardStackElements.parseParam(s, "highest_from_group_");
        if (p != null) {
            return StandardStackElements.highestFromGroup(p);
        }
        p = StandardStackElements.parseParam(s, "lowest_from_group_");
        if (p != null) {
            return StandardStackElements.lowestFromGroup(p);
        }
        p = StandardStackElements.parseParam(s, "highest_not_from_group_");
        if (p != null) {
            return StandardStackElements.highestNotFromGroup(p);
        }
        p = StandardStackElements.parseParam(s, "lowest_not_from_group_");
        if (p != null) {
            return StandardStackElements.lowestNotFromGroup(p);
        }
        return null;
    }

    private static String parseParam(String s, String prefix) {
        if (s.startsWith(prefix) && s.length() > prefix.length()) {
            return s.substring(prefix.length());
        }
        return null;
    }

    public static List<MetaStackElement> parseList(LuckPermsPlugin plugin, List<String> strings) {
        return (List)strings.stream().map(s -> {
            MetaStackElement parsed = StandardStackElements.parseFromString(plugin, s);
            if (parsed == null) {
                plugin.getLogger().warn("Unable to parse from: " + s, new IllegalArgumentException());
            }
            return parsed;
        }).filter(Objects::nonNull).collect(ImmutableCollectors.toList());
    }

    public static MetaStackElement highestFromGroupOnTrack(LuckPermsPlugin plugin, String trackName) {
        return FluentMetaStackElement.builder("HighestPriorityOnTrack").param("trackName", trackName).with(TYPE_CHECK).with(HIGHEST_CHECK).with(new FromGroupOnTrackCheck(plugin, trackName)).build();
    }

    public static MetaStackElement highestNotFromGroupOnTrack(LuckPermsPlugin plugin, String trackName) {
        return FluentMetaStackElement.builder("HighestPriorityNotOnTrack").param("trackName", trackName).with(TYPE_CHECK).with(HIGHEST_CHECK).with(new NotFromGroupOnTrackCheck(plugin, trackName)).build();
    }

    public static MetaStackElement highestFromGroup(String groupName) {
        return FluentMetaStackElement.builder("HighestPriorityFromGroup").param("groupName", groupName).with(TYPE_CHECK).with(HIGHEST_CHECK).with(new FromGroupCheck(groupName)).build();
    }

    public static MetaStackElement highestNotFromGroup(String groupName) {
        return FluentMetaStackElement.builder("HighestPriorityNotFromGroup").param("groupName", groupName).with(TYPE_CHECK).with(HIGHEST_CHECK).with(new NotFromGroupCheck(groupName)).build();
    }

    public static MetaStackElement lowestFromGroupOnTrack(LuckPermsPlugin plugin, String trackName) {
        return FluentMetaStackElement.builder("LowestPriorityOnTrack").param("trackName", trackName).with(TYPE_CHECK).with(LOWEST_CHECK).with(new FromGroupOnTrackCheck(plugin, trackName)).build();
    }

    public static MetaStackElement lowestNotFromGroupOnTrack(LuckPermsPlugin plugin, String trackName) {
        return FluentMetaStackElement.builder("LowestPriorityNotOnTrack").param("trackName", trackName).with(TYPE_CHECK).with(LOWEST_CHECK).with(new NotFromGroupOnTrackCheck(plugin, trackName)).build();
    }

    public static MetaStackElement lowestFromGroup(String groupName) {
        return FluentMetaStackElement.builder("LowestPriorityFromGroup").param("groupName", groupName).with(TYPE_CHECK).with(LOWEST_CHECK).with(new FromGroupCheck(groupName)).build();
    }

    public static MetaStackElement lowestNotFromGroup(String groupName) {
        return FluentMetaStackElement.builder("LowestPriorityNotFromGroup").param("groupName", groupName).with(TYPE_CHECK).with(LOWEST_CHECK).with(new NotFromGroupCheck(groupName)).build();
    }

    private static final class FromGroupOnTrackCheck
    implements MetaStackElement {
        private final LuckPermsPlugin plugin;
        private final String trackName;

        FromGroupOnTrackCheck(LuckPermsPlugin plugin, String trackName) {
            this.plugin = plugin;
            this.trackName = trackName;
        }

        @Override
        public boolean shouldAccumulate(@NonNull ChatMetaType type, @NonNull ChatMetaNode<?, ?> node, @Nullable ChatMetaNode<?, ?> current) {
            Track track = (Track)this.plugin.getTrackManager().getIfLoaded(this.trackName);
            if (track == null) {
                return false;
            }
            PermissionHolder.Identifier origin = node.metadata(InheritanceOriginMetadata.KEY).getOrigin();
            return origin.getType().equals("group") && track.containsGroup(origin.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FromGroupOnTrackCheck that = (FromGroupOnTrackCheck)o;
            return this.trackName.equals(that.trackName);
        }

        public int hashCode() {
            return this.trackName.hashCode();
        }
    }

    private static final class NotFromGroupOnTrackCheck
    implements MetaStackElement {
        private final LuckPermsPlugin plugin;
        private final String trackName;

        NotFromGroupOnTrackCheck(LuckPermsPlugin plugin, String trackName) {
            this.plugin = plugin;
            this.trackName = trackName;
        }

        @Override
        public boolean shouldAccumulate(@NonNull ChatMetaType type, @NonNull ChatMetaNode<?, ?> node, @Nullable ChatMetaNode<?, ?> current) {
            Track track = (Track)this.plugin.getTrackManager().getIfLoaded(this.trackName);
            if (track == null) {
                return false;
            }
            PermissionHolder.Identifier origin = node.metadata(InheritanceOriginMetadata.KEY).getOrigin();
            return !origin.getType().equals("group") || !track.containsGroup(origin.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotFromGroupOnTrackCheck that = (NotFromGroupOnTrackCheck)o;
            return this.trackName.equals(that.trackName);
        }

        public int hashCode() {
            return this.trackName.hashCode();
        }
    }

    private static final class FromGroupCheck
    implements MetaStackElement {
        private final String groupName;

        FromGroupCheck(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public boolean shouldAccumulate(@NonNull ChatMetaType type, @NonNull ChatMetaNode<?, ?> node, @Nullable ChatMetaNode<?, ?> current) {
            PermissionHolder.Identifier origin = node.metadata(InheritanceOriginMetadata.KEY).getOrigin();
            return origin.getType().equals("group") && this.groupName.equals(origin.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FromGroupCheck that = (FromGroupCheck)o;
            return this.groupName.equals(that.groupName);
        }

        public int hashCode() {
            return this.groupName.hashCode();
        }
    }

    private static final class NotFromGroupCheck
    implements MetaStackElement {
        private final String groupName;

        NotFromGroupCheck(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public boolean shouldAccumulate(@NonNull ChatMetaType type, @NonNull ChatMetaNode<?, ?> node, @Nullable ChatMetaNode<?, ?> current) {
            PermissionHolder.Identifier origin = node.metadata(InheritanceOriginMetadata.KEY).getOrigin();
            return !origin.getType().equals("group") || !this.groupName.equals(origin.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotFromGroupCheck that = (NotFromGroupCheck)o;
            return this.groupName.equals(that.groupName);
        }

        public int hashCode() {
            return this.groupName.hashCode();
        }
    }
}

