/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.result;

import me.lucko.luckperms.common.cacheddata.result.AbstractResult;
import me.lucko.luckperms.common.cacheddata.result.StringResult;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.WeightNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class IntegerResult<N extends Node>
extends AbstractResult<Integer, N, IntegerResult<N>> {
    private final int result;
    private static final IntegerResult<?> NULL_RESULT = new IntegerResult<Object>(0, null, null);

    public IntegerResult(int result, N node, IntegerResult<N> overriddenResult) {
        super(node, overriddenResult);
        this.result = result;
    }

    @Override
    @Deprecated
    public @NonNull Integer result() {
        return this.result;
    }

    public int intResult() {
        return this.result;
    }

    public StringResult<N> asStringResult() {
        if (this.isNull()) {
            return StringResult.nullResult();
        }
        StringResult<Node> result = StringResult.of(Integer.toString(this.result), this.node);
        if (this.overriddenResult != null) {
            result.setOverriddenResult(((IntegerResult)this.overriddenResult).asStringResult());
        }
        return result;
    }

    public boolean isNull() {
        return this == NULL_RESULT;
    }

    public IntegerResult<N> copy() {
        return new IntegerResult<Node>(this.result, this.node, (IntegerResult)this.overriddenResult);
    }

    public String toString() {
        return "IntegerResult(result=" + this.result + ", node=" + String.valueOf(this.node) + ", overriddenResult=" + String.valueOf(this.overriddenResult) + ")";
    }

    public static <N extends Node> IntegerResult<N> nullResult() {
        return NULL_RESULT;
    }

    public static <N extends Node> IntegerResult<N> of(int result) {
        return new IntegerResult<Object>(result, null, null);
    }

    public static <N extends Node> IntegerResult<N> of(int result, N node) {
        return new IntegerResult<N>(result, node, null);
    }

    public static IntegerResult<WeightNode> of(WeightNode node) {
        return new IntegerResult<WeightNode>(node.getWeight(), node, null);
    }
}

