/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.other;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.data.DataType;

public class HolderClear<T extends PermissionHolder>
extends ChildCommand<T> {
    public HolderClear(HolderType type) {
        super(CommandSpec.HOLDER_CLEAR, "clear", type == HolderType.USER ? CommandPermission.USER_CLEAR : CommandPermission.GROUP_CLEAR, Predicates.alwaysFalse());
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, T target, ArgumentList args, String label) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        int before = ((PermissionHolder)target).normalData().size();
        MutableContextSet context = args.getContextOrDefault(0, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, this.getPermission().get(), context) || ArgumentPermissions.checkGroup(plugin, sender, target, (ContextSet)context)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        if (context.isEmpty()) {
            ((PermissionHolder)target).clearNodes(DataType.NORMAL, null, true);
        } else {
            ((PermissionHolder)target).clearNodes(DataType.NORMAL, context, true);
        }
        int changed = before - ((PermissionHolder)target).normalData().size();
        Message.CLEAR_SUCCESS.send(sender, (PermissionHolder)target, context, changed);
        LoggedAction.build().source(sender).target((PermissionHolder)target).description("clear", context).build().submit(plugin, sender);
        StorageAssistant.save(target, sender, plugin);
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().from(0, TabCompletions.contexts(plugin)).complete((List<String>)((Object)args));
    }
}

