/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.parent;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.NodeType;

public class ParentClear
extends GenericChildCommand {
    public ParentClear() {
        super(CommandSpec.PARENT_CLEAR, "clear", CommandPermission.USER_PARENT_CLEAR, CommandPermission.GROUP_PARENT_CLEAR, Predicates.alwaysFalse());
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder target, ArgumentList args, String label, CommandPermission permission) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, permission, target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        int before = target.normalData().size();
        MutableContextSet context = args.getContextOrDefault(0, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, permission, context) || ArgumentPermissions.checkGroup(plugin, sender, target, (ContextSet)context)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        if (context.isEmpty()) {
            target.removeIf(DataType.NORMAL, null, NodeType.INHERITANCE::matches, true);
        } else {
            target.removeIf(DataType.NORMAL, context, NodeType.INHERITANCE::matches, true);
        }
        int changed = before - target.normalData().size();
        Message.PARENT_CLEAR_SUCCESS.send(sender, target, context, changed);
        LoggedAction.build().source(sender).target(target).description("parent", "clear", context).build().submit(plugin, sender);
        StorageAssistant.save(target, sender, plugin);
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().from(0, TabCompletions.contexts(plugin)).complete((List<String>)((Object)args));
    }
}

