/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import java.util.List;
import java.util.Locale;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.model.data.DataMutateResult;

public class TrackAppend
extends ChildCommand<Track> {
    public TrackAppend() {
        super(CommandSpec.TRACK_APPEND, "append", CommandPermission.TRACK_APPEND, Predicates.not(1));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Track target, ArgumentList args, String label) {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        String groupName = args.get(0).toLowerCase(Locale.ROOT);
        if (!DataConstraints.GROUP_NAME_TEST.test(groupName)) {
            this.sendDetailedUsage(sender, label);
            return;
        }
        Group group = StorageAssistant.loadGroup(groupName, sender, plugin, false);
        if (group == null) {
            return;
        }
        DataMutateResult result = target.appendGroup(group);
        if (result.wasSuccessful()) {
            Message.TRACK_APPEND_SUCCESS.send(sender, group.getName(), target.getName());
            if (target.getGroups().size() > 1) {
                Message.TRACK_PATH_HIGHLIGHTED.send(sender, target.getGroups(), group.getName());
            }
            LoggedAction.build().source(sender).target(target).description("append", group.getName()).build().submit(plugin, sender);
            StorageAssistant.save(target, sender, plugin);
        } else {
            Message.TRACK_ALREADY_CONTAINS.send(sender, target.getName(), group);
        }
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, TabCompletions.groups(plugin)).complete((List<String>)((Object)args));
    }
}

