/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import java.util.Locale;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.lib.adventure.text.Component;
import net.luckperms.api.event.cause.CreationCause;

public class TrackClone
extends ChildCommand<Track> {
    public TrackClone() {
        super(CommandSpec.TRACK_CLONE, "clone", CommandPermission.TRACK_CLONE, Predicates.not(1));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Track target, ArgumentList args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        String newTrackName = args.get(0).toLowerCase(Locale.ROOT);
        if (!DataConstraints.TRACK_NAME_TEST.test(newTrackName)) {
            Message.TRACK_INVALID_ENTRY.send(sender, newTrackName);
            return;
        }
        Track newTrack = plugin.getStorage().createAndLoadTrack(newTrackName, CreationCause.INTERNAL).join();
        if (newTrack == null) {
            Message.TRACK_LOAD_ERROR.send(sender);
            return;
        }
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), newTrack)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        newTrack.setGroups(target.getGroups());
        Message.CLONE_SUCCESS.send(sender, (Component)Component.text((String)target.getName()), (Component)Component.text((String)newTrack.getName()));
        LoggedAction.build().source(sender).target(target).description("clone", newTrack.getName()).build().submit(plugin, sender);
        StorageAssistant.save(newTrack, sender, plugin);
    }
}

