/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context.manager;

import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.context.manager.ContextManager;
import me.lucko.luckperms.common.context.manager.QueryOptionsCache;
import me.lucko.luckperms.common.context.manager.QueryOptionsSupplier;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class DetachedContextManager<S, P extends S>
extends ContextManager<S, P> {
    private final LoadingCache<S, QueryOptions> fallbackContextsCache = CaffeineFactory.newBuilder().expireAfterWrite(50L, TimeUnit.MILLISECONDS).build(this::calculate);

    protected DetachedContextManager(LuckPermsPlugin plugin, Class<S> subjectClass, Class<P> playerClass) {
        super(plugin, subjectClass, playerClass);
    }

    @Override
    public QueryOptions getQueryOptions(S subject) {
        QueryOptionsSupplier supplier = this.getQueryOptionsSupplier(subject);
        if (supplier != null) {
            return supplier.getQueryOptions();
        }
        return (QueryOptions)this.fallbackContextsCache.get(subject);
    }

    @Override
    public void invalidateCache(S subject) {
        QueryOptionsSupplier queryOptionsSupplier = this.getQueryOptionsSupplier(subject);
        if (queryOptionsSupplier != null) {
            queryOptionsSupplier.invalidateCache();
        }
        this.fallbackContextsCache.invalidate(subject);
    }

    public QueryOptionsSupplier createQueryOptionsSupplier(S subject) {
        return new QueryOptionsCache<S>(subject, this);
    }

    public abstract @Nullable QueryOptionsSupplier getQueryOptionsSupplier(S var1);
}

