/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.filter;

import java.util.regex.Pattern;

public enum Comparison {
    EQUAL("=="),
    NOT_EQUAL("!="),
    SIMILAR("~~"),
    NOT_SIMILAR("!~");

    public static final String WILDCARD = "%";
    public static final String WILDCARD_ONE = "_";
    private final String symbol;

    private Comparison(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public static Comparison parse(String s) {
        for (Comparison t : Comparison.values()) {
            if (!t.getSymbol().equals(s)) continue;
            return t;
        }
        return null;
    }

    public static Pattern compilePatternForLikeSyntax(String expression) {
        expression = expression.replace(".", "\\.");
        expression = expression.replace(WILDCARD_ONE, ".");
        expression = expression.replace(WILDCARD, ".*");
        return Pattern.compile(expression, 2);
    }
}

