/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.filter;

import java.util.function.Function;
import me.lucko.luckperms.common.filter.Comparison;
import me.lucko.luckperms.common.filter.ConstraintFactory;
import me.lucko.luckperms.common.filter.Filter;

public interface FilterField<T, FT> {
    public static <T, FT> FilterField<T, FT> named(final String name, final Function<T, FT> func) {
        return new FilterField<T, FT>(){

            @Override
            public FT getValue(T object) {
                return func.apply(object);
            }

            public String toString() {
                return name;
            }
        };
    }

    public FT getValue(T var1);

    default public Filter<T, FT> isEqualTo(FT value, ConstraintFactory<FT> factory) {
        return new Filter(this, factory.build(Comparison.EQUAL, value));
    }

    default public Filter<T, FT> isNotEqualTo(FT value, ConstraintFactory<FT> factory) {
        return new Filter(this, factory.build(Comparison.NOT_EQUAL, value));
    }

    default public Filter<T, FT> isSimilarTo(FT value, ConstraintFactory<FT> factory) {
        return new Filter(this, factory.build(Comparison.SIMILAR, value));
    }

    default public Filter<T, FT> isNotSimilarTo(FT value, ConstraintFactory<FT> factory) {
        return new Filter(this, factory.build(Comparison.NOT_SIMILAR, value));
    }
}

