/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.message;

import com.google.gson.JsonElement;
import java.util.UUID;
import me.lucko.luckperms.common.messaging.LuckPermsMessagingService;
import me.lucko.luckperms.common.messaging.message.AbstractMessage;
import me.lucko.luckperms.common.util.gson.JObject;
import net.luckperms.api.messenger.message.type.UserUpdateMessage;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UserUpdateMessageImpl
extends AbstractMessage
implements UserUpdateMessage {
    public static final String TYPE = "userupdate";
    private final UUID userUuid;

    public static UserUpdateMessageImpl decode(@Nullable JsonElement content, UUID id) {
        if (content == null) {
            throw new IllegalStateException("Missing content");
        }
        JsonElement uuidElement = content.getAsJsonObject().get("userUuid");
        if (uuidElement == null) {
            throw new IllegalStateException("Incoming message has no userUuid argument: " + String.valueOf(content));
        }
        UUID userUuid = UUID.fromString(uuidElement.getAsString());
        return new UserUpdateMessageImpl(id, userUuid);
    }

    public UserUpdateMessageImpl(UUID id, UUID userUuid) {
        super(id);
        this.userUuid = userUuid;
    }

    @Override
    public @NonNull UUID getUserUniqueId() {
        return this.userUuid;
    }

    @Override
    public @NonNull String asEncodedString() {
        return LuckPermsMessagingService.encodeMessageAsString(TYPE, this.getId(), (JsonElement)new JObject().add("userUuid", this.userUuid.toString()).toJson());
    }
}

