/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.luckperms.api.messenger.IncomingMessageConsumer;
import net.luckperms.api.messenger.Messenger;
import net.luckperms.api.messenger.message.OutgoingMessage;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractSqlMessenger
implements Messenger {
    private final IncomingMessageConsumer consumer;
    private long lastId = -1L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean closed = false;

    protected AbstractSqlMessenger(IncomingMessageConsumer consumer) {
        this.consumer = consumer;
    }

    protected abstract Connection getConnection() throws SQLException;

    protected abstract String getTableName();

    public void init() throws SQLException {
        try (Connection c = this.getConnection();){
            block28: {
                String createStatement = "CREATE TABLE IF NOT EXISTS `" + this.getTableName() + "` (`id` INT AUTO_INCREMENT NOT NULL, `time` TIMESTAMP NOT NULL, `msg` TEXT NOT NULL, PRIMARY KEY (`id`)) DEFAULT CHARSET = utf8mb4";
                try (Statement s = c.createStatement();){
                    try {
                        s.execute(createStatement);
                    }
                    catch (SQLException e) {
                        if (e.getMessage().contains("Unknown character set")) {
                            s.execute(createStatement.replace("utf8mb4", "utf8"));
                            break block28;
                        }
                        throw e;
                    }
                }
            }
            try (PreparedStatement ps = c.prepareStatement("SELECT MAX(`id`) as `latest` FROM `" + this.getTableName() + "`");
                 ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    this.lastId = rs.getLong("latest");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOutgoingMessage(@NonNull OutgoingMessage outgoingMessage) {
        this.lock.readLock().lock();
        if (this.closed) {
            this.lock.readLock().unlock();
            return;
        }
        try (Connection c = this.getConnection();
             PreparedStatement ps = c.prepareStatement("INSERT INTO `" + this.getTableName() + "` (`time`, `msg`) VALUES(NOW(), ?)");){
            ps.setString(1, outgoingMessage.asEncodedString());
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollMessages() {
        this.lock.readLock().lock();
        if (this.closed) {
            this.lock.readLock().unlock();
            return;
        }
        try (Connection c = this.getConnection();
             PreparedStatement ps = c.prepareStatement("SELECT `id`, `msg` FROM `" + this.getTableName() + "` WHERE `id` > ? AND (NOW() - `time` < 30)");){
            ps.setLong(1, this.lastId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long id = rs.getLong("id");
                    this.lastId = Math.max(this.lastId, id);
                    String message = rs.getString("msg");
                    this.consumer.consumeIncomingMessageAsString(message);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHousekeeping() {
        this.lock.readLock().lock();
        if (this.closed) {
            this.lock.readLock().unlock();
            return;
        }
        try (Connection c = this.getConnection();
             PreparedStatement ps = c.prepareStatement("DELETE FROM `" + this.getTableName() + "` WHERE (NOW() - `time` > 60)");){
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            this.closed = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

