/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model.nodemap;

import com.google.common.collect.ImmutableCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Consumer;
import me.lucko.luckperms.common.model.nodemap.NodeMap;
import net.luckperms.api.context.ContextSatisfyMode;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.Flag;
import net.luckperms.api.query.QueryOptions;

abstract class NodeMapBase
implements NodeMap {
    NodeMapBase() {
    }

    protected abstract SortedMap<ImmutableContextSet, SortedSet<Node>> map();

    protected abstract SortedMap<ImmutableContextSet, SortedSet<InheritanceNode>> inheritanceMap();

    protected abstract ContextSatisfyMode defaultSatisfyMode();

    @Override
    public boolean isEmpty() {
        return this.map().isEmpty();
    }

    @Override
    public int size() {
        int size = 0;
        for (SortedSet<Node> values : this.map().values()) {
            size += values.size();
        }
        return size;
    }

    @Override
    public Map<ImmutableContextSet, Collection<Node>> asMap() {
        HashMap<ImmutableContextSet, Collection<Node>> map = new HashMap<ImmutableContextSet, Collection<Node>>();
        for (Map.Entry<ImmutableContextSet, SortedSet<Node>> e : this.map().entrySet()) {
            map.put(e.getKey(), new ArrayList(e.getValue()));
        }
        return map;
    }

    @Override
    public Map<ImmutableContextSet, Collection<InheritanceNode>> inheritanceAsMap() {
        HashMap<ImmutableContextSet, Collection<InheritanceNode>> map = new HashMap<ImmutableContextSet, Collection<InheritanceNode>>();
        for (Map.Entry<ImmutableContextSet, SortedSet<InheritanceNode>> e : this.inheritanceMap().entrySet()) {
            map.put(e.getKey(), new ArrayList(e.getValue()));
        }
        return map;
    }

    @Override
    public void forEach(Consumer<? super Node> consumer) {
        for (SortedSet<Node> values : this.map().values()) {
            values.forEach(consumer);
        }
    }

    @Override
    public void forEach(QueryOptions filter, Consumer<? super Node> consumer) {
        for (Map.Entry<ImmutableContextSet, SortedSet<Node>> e : this.map().entrySet()) {
            if (!filter.satisfies(e.getKey(), this.defaultSatisfyMode())) continue;
            if (NodeMapBase.normalNodesExcludeTest(filter, e.getKey())) {
                SortedSet inheritanceNodes;
                if (!NodeMapBase.inheritanceNodesIncludeTest(filter, e.getKey()) || (inheritanceNodes = (SortedSet)this.inheritanceMap().get(e.getKey())) == null) continue;
                inheritanceNodes.forEach(consumer);
                continue;
            }
            e.getValue().forEach(consumer);
        }
    }

    @Override
    public void copyTo(Collection<? super Node> collection) {
        for (SortedSet<Node> values : this.map().values()) {
            collection.addAll(values);
        }
    }

    @Override
    public void copyTo(ImmutableCollection.Builder<? super Node> collection) {
        for (SortedSet<Node> values : this.map().values()) {
            collection.addAll(values);
        }
    }

    @Override
    public void copyTo(Collection<? super Node> collection, QueryOptions filter) {
        for (Map.Entry<ImmutableContextSet, SortedSet<Node>> e : this.map().entrySet()) {
            if (!filter.satisfies(e.getKey(), this.defaultSatisfyMode())) continue;
            if (NodeMapBase.normalNodesExcludeTest(filter, e.getKey())) {
                SortedSet inheritanceNodes;
                if (!NodeMapBase.inheritanceNodesIncludeTest(filter, e.getKey()) || (inheritanceNodes = (SortedSet)this.inheritanceMap().get(e.getKey())) == null) continue;
                collection.addAll(inheritanceNodes);
                continue;
            }
            collection.addAll((Collection<? super Node>)e.getValue());
        }
    }

    @Override
    public <T extends Node> void copyTo(Collection<? super T> collection, NodeType<T> type, QueryOptions filter) {
        if (type == NodeType.INHERITANCE) {
            this.copyInheritanceNodesTo(collection, filter);
            return;
        }
        for (Map.Entry<ImmutableContextSet, SortedSet<Node>> e : this.map().entrySet()) {
            if (!filter.satisfies(e.getKey(), this.defaultSatisfyMode()) || NodeMapBase.normalNodesExcludeTest(filter, e.getKey())) continue;
            for (Node node : e.getValue()) {
                if (!type.matches(node)) continue;
                collection.add(type.cast(node));
            }
        }
    }

    @Override
    public void copyInheritanceNodesTo(Collection<? super InheritanceNode> collection) {
        for (SortedSet<InheritanceNode> values : this.inheritanceMap().values()) {
            collection.addAll(values);
        }
    }

    @Override
    public void copyInheritanceNodesTo(ImmutableCollection.Builder<? super InheritanceNode> collection) {
        for (SortedSet<InheritanceNode> values : this.inheritanceMap().values()) {
            collection.addAll(values);
        }
    }

    @Override
    public void copyInheritanceNodesTo(Collection<? super InheritanceNode> collection, QueryOptions filter) {
        for (Map.Entry<ImmutableContextSet, SortedSet<InheritanceNode>> e : this.inheritanceMap().entrySet()) {
            if (!filter.satisfies(e.getKey(), this.defaultSatisfyMode()) || !NodeMapBase.inheritanceNodesIncludeTest(filter, e.getKey())) continue;
            collection.addAll((Collection<? super InheritanceNode>)e.getValue());
        }
    }

    @Override
    public Collection<Node> nodesInContext(ContextSet context) {
        return NodeMapBase.copy((Collection)this.map().get(context.immutableCopy()));
    }

    @Override
    public Collection<InheritanceNode> inheritanceNodesInContext(ContextSet context) {
        return NodeMapBase.copy((Collection)this.inheritanceMap().get(context.immutableCopy()));
    }

    private static <T> Collection<T> copy(Collection<T> collection) {
        if (collection == null) {
            return Collections.emptySet();
        }
        return new ArrayList<T>(collection);
    }

    private static boolean flagExcludeTest(Flag flag, String contextKey, QueryOptions filter, ImmutableContextSet contextSet) {
        return !filter.flag(flag) && !contextSet.containsKey(contextKey);
    }

    private static boolean normalNodesExcludeTest(QueryOptions filter, ImmutableContextSet contextSet) {
        return NodeMapBase.flagExcludeTest(Flag.INCLUDE_NODES_WITHOUT_SERVER_CONTEXT, "server", filter, contextSet) || NodeMapBase.flagExcludeTest(Flag.INCLUDE_NODES_WITHOUT_WORLD_CONTEXT, "world", filter, contextSet);
    }

    private static boolean inheritanceNodesIncludeTest(QueryOptions filter, ImmutableContextSet contextSet) {
        return !NodeMapBase.flagExcludeTest(Flag.APPLY_INHERITANCE_NODES_WITHOUT_SERVER_CONTEXT, "server", filter, contextSet) && !NodeMapBase.flagExcludeTest(Flag.APPLY_INHERITANCE_NODES_WITHOUT_WORLD_CONTEXT, "world", filter, contextSet);
    }
}

